/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import java.awt.Rectangle;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageLabel;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.ToggleButton;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.Achievements;
import mcjty.rftools.blocks.dimletconstruction.DimletWorkbenchContainer;
import mcjty.rftools.blocks.dimletconstruction.DimletWorkbenchTileEntity;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.network.Argument;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiDimletWorkbench
extends GenericGuiContainer<DimletWorkbenchTileEntity> {
    public static final int WORKBENCH_WIDTH = 200;
    public static final int WORKBENCH_HEIGHT = 224;
    private EnergyBar energyBar;
    private Button extractButton;
    private ToggleButton autoExtract;
    private ImageLabel progressIcon;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/dimletworkbench.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiDimletWorkbench(DimletWorkbenchTileEntity dimletWorkbenchTileEntity, DimletWorkbenchContainer container) {
        super(dimletWorkbenchTileEntity, container);
        this.field_146999_f = 200;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((DimletWorkbenchTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(new PositionalLayout.PositionalHint(8, 142, 8, 54))).setShowText(false);
        DimletWorkbenchTileEntity cfr_ignored_0 = (DimletWorkbenchTileEntity)this.tileEntity;
        this.energyBar.setValue(DimletWorkbenchTileEntity.getCurrentRF());
        this.progressIcon = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 64, 16);
        this.progressIcon.setLayoutHint(new PositionalLayout.PositionalHint(135, 6, 16, 16));
        this.extractButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Extract")).setLayoutHint(new PositionalLayout.PositionalHint(40, 7, 55, 14))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDimletWorkbench.this.extractDimlet();
            }
        }).setTooltips(new String[]{"Deconstruct a dimlet into its parts"});
        this.autoExtract = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setText("Auto")).setLayoutHint(new PositionalLayout.PositionalHint(100, 7, 30, 14))).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDimletWorkbench.this.setAutoExtract();
            }
        }).setTooltips(new String[]{"Automatically extract"})).setCheckMarker(true);
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout()).addChild(this.extractButton)).addChild(this.energyBar)).addChild(this.progressIcon)).addChild(this.autoExtract);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setAutoExtract() {
        this.sendServerCommand("setAutoExtract", new Argument("auto", this.autoExtract.isPressed()));
    }

    private void extractDimlet() {
        DimletKey key;
        ItemStack itemStack;
        Slot slot = this.field_147002_h.func_75139_a(0);
        if (slot.func_75211_c() != null && ((Object)((Object)ModItems.knownDimlet)).equals((itemStack = slot.func_75211_c()).func_77973_b()) && !KnownDimletConfiguration.craftableDimlets.contains(key = KnownDimletConfiguration.getDimletKey(itemStack, (World)Minecraft.func_71410_x().field_71441_e))) {
            Achievements.trigger((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Achievements.smallBits);
            this.sendServerCommand("startExtract", new Argument[0]);
        }
    }

    private void enableButtons() {
        DimletKey key;
        ItemStack itemStack;
        boolean enabled = false;
        Slot slot = this.field_147002_h.func_75139_a(0);
        if (slot.func_75211_c() != null && ((Object)((Object)ModItems.knownDimlet)).equals((itemStack = slot.func_75211_c()).func_77973_b()) && !KnownDimletConfiguration.craftableDimlets.contains(key = KnownDimletConfiguration.getDimletKey(itemStack, (World)Minecraft.func_71410_x().field_71441_e))) {
            enabled = true;
        }
        this.extractButton.setEnabled(enabled);
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.enableButtons();
        int extracting = ((DimletWorkbenchTileEntity)this.tileEntity).getExtracting();
        if (extracting == 0) {
            this.progressIcon.setImage(iconGuiElements, 64, 16);
        } else {
            this.progressIcon.setImage(iconGuiElements, extracting % 4 * 16, 16);
        }
        this.window.draw();
        DimletWorkbenchTileEntity cfr_ignored_0 = (DimletWorkbenchTileEntity)this.tileEntity;
        this.energyBar.setValue(DimletWorkbenchTileEntity.getCurrentRF());
        ((DimletWorkbenchTileEntity)this.tileEntity).requestRfFromServer();
        ((DimletWorkbenchTileEntity)this.tileEntity).requestExtractingFromServer();
    }
}

