/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.gui.RenderHelper;
import mcjty.gui.Scrollable;
import mcjty.gui.Window;
import mcjty.gui.events.SelectionEvent;
import mcjty.gui.widgets.AbstractContainerWidget;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class WidgetList
extends AbstractContainerWidget<WidgetList>
implements Scrollable {
    private int rowheight = 16;
    private int first = 0;
    private int selected = -1;
    private long prevTime = -1L;
    private boolean propagateEventsToChildren = false;
    private List<SelectionEvent> selectionEvents = null;
    private Set<Integer> hilightedRows = new HashSet<Integer>();

    public WidgetList(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public int getRowheight() {
        return this.rowheight;
    }

    public WidgetList setRowheight(int rowheight) {
        this.rowheight = rowheight;
        return this;
    }

    public int getSelected() {
        return this.selected;
    }

    public WidgetList setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public boolean isPropagateEventsToChildren() {
        return this.propagateEventsToChildren;
    }

    public WidgetList setPropagateEventsToChildren(boolean propagateEventsToChildren) {
        this.propagateEventsToChildren = propagateEventsToChildren;
        return this;
    }

    public void addHilightedRow(int index) {
        this.hilightedRows.add(index);
    }

    public void clearHilightedRows() {
        this.hilightedRows.clear();
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        this.mouseWheel(0, x, y);
        super.draw(window, x, y);
        int xx = x + this.bounds.x + 2;
        int yy = y + this.bounds.y + 1;
        int top = 0;
        for (int i = this.first; i < this.first + this.getCountSelected() && i < this.children.size(); ++i) {
            Widget child = (Widget)this.children.get(i);
            child.setBounds(new Rectangle(0, top, this.bounds.width, this.rowheight));
            boolean hilighted = this.hilightedRows.contains(i);
            if (i == this.selected && hilighted) {
                RenderHelper.drawHorizontalGradientRect(xx, yy + top, xx + this.bounds.width - 4, yy + top + this.rowheight, -7829436, -10066398);
            } else if (i == this.selected) {
                RenderHelper.drawHorizontalGradientRect(xx, yy + top, xx + this.bounds.width - 4, yy + top + this.rowheight, -10066330, -12303292);
            } else if (hilighted) {
                RenderHelper.drawHorizontalGradientRect(xx, yy + top, xx + this.bounds.width - 4, yy + top + this.rowheight, -4474112, -6711040);
            }
            if (this.isEnabledAndVisible()) {
                child.draw(window, xx, yy);
            } else {
                boolean en = child.isEnabled();
                child.setEnabled(false);
                child.draw(window, xx, yy);
                child.setEnabled(en);
            }
            top += this.rowheight;
        }
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        int yy;
        int xx;
        Widget child;
        if (!this.isEnabledAndVisible()) {
            return null;
        }
        int newSelected = -1;
        int top = this.bounds.y;
        for (int i = this.first; i < this.first + this.getCountSelected() && i < this.children.size(); ++i) {
            Rectangle r = new Rectangle(this.bounds.x, top, this.bounds.width, this.rowheight);
            if (r.contains(x, y)) {
                newSelected = i;
                break;
            }
            top += this.rowheight;
        }
        if (newSelected != this.selected) {
            this.selected = newSelected;
            this.fireSelectionEvents(this.selected);
        }
        if (this.propagateEventsToChildren && this.selected != -1 && (child = (Widget)this.children.get(this.selected)).in(xx = x - this.bounds.x, yy = y - this.bounds.y) && child.isVisible()) {
            child.mouseClick(window, xx, yy, button);
        }
        long t = System.currentTimeMillis();
        if (this.prevTime != -1L && t - this.prevTime < 250L) {
            this.fireDoubleClickEvent(this.selected);
        }
        this.prevTime = t;
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
    }

    @Override
    public boolean mouseWheel(int amount, int x, int y) {
        int divider = this.getMaximum() - this.getCountSelected();
        if (divider <= 0) {
            this.first = 0;
        } else if (amount > 0) {
            this.first -= 3;
        } else if (amount < 0) {
            this.first += 3;
        }
        if (this.first > divider) {
            this.first = divider;
        }
        if (this.first < 0) {
            this.first = 0;
        }
        return true;
    }

    @Override
    public int getMaximum() {
        return this.children.size();
    }

    @Override
    public int getCountSelected() {
        return this.bounds.height / this.rowheight;
    }

    @Override
    public int getFirstSelected() {
        return this.first;
    }

    @Override
    public void setFirstSelected(int first) {
        this.first = first;
    }

    public WidgetList addSelectionEvent(SelectionEvent event) {
        if (this.selectionEvents == null) {
            this.selectionEvents = new ArrayList<SelectionEvent>();
        }
        this.selectionEvents.add(event);
        return this;
    }

    public void removeSelectionEvent(SelectionEvent event) {
        if (this.selectionEvents != null) {
            this.selectionEvents.remove(event);
        }
    }

    private void fireSelectionEvents(int index) {
        if (this.selectionEvents != null) {
            for (SelectionEvent event : this.selectionEvents) {
                event.select(this, index);
            }
        }
    }

    private void fireDoubleClickEvent(int index) {
        if (this.selectionEvents != null) {
            for (SelectionEvent event : this.selectionEvents) {
                event.doubleClick(this, index);
            }
        }
    }

    @Override
    public WidgetList removeChild(Widget child) {
        int index = this.children.indexOf(child);
        if (index != -1) {
            HashSet<Integer> newHighlights = new HashSet<Integer>();
            for (Integer i : this.hilightedRows) {
                if (i < index) {
                    newHighlights.add(i);
                    continue;
                }
                if (i <= index) continue;
                newHighlights.add(i - 1);
            }
            this.hilightedRows = newHighlights;
        }
        return (WidgetList)super.removeChild(child);
    }

    @Override
    public void removeChildren() {
        super.removeChildren();
        this.hilightedRows.clear();
    }
}

