/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import mcjty.gui.Scrollable;
import mcjty.gui.events.ValueEvent;
import mcjty.gui.widgets.Label;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class ScrollableLabel
extends Label<ScrollableLabel>
implements Scrollable {
    private int realmin = 0;
    private int realmax = 100;
    private int first = 0;
    private String suffix = "";
    private List<ValueEvent> valueEvents = null;

    public ScrollableLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setFirstSelected(0);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public ScrollableLabel setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public ScrollableLabel setRealMaximum(int realmax) {
        this.realmax = realmax;
        if (this.first > realmax - this.realmin) {
            this.first = realmax - this.realmin;
        }
        this.setFirstSelected(this.first);
        return this;
    }

    public int getRealMaximum() {
        return this.realmax;
    }

    public int getRealValue() {
        return this.first + this.realmin;
    }

    public ScrollableLabel setRealValue(int value) {
        int f = value - this.realmin;
        if (f < 0) {
            f = 0;
        }
        this.setFirstSelected(f);
        return this;
    }

    public ScrollableLabel setRealMinimum(int realmin) {
        this.realmin = realmin;
        if (this.first < 0) {
            this.first = 0;
        }
        this.setFirstSelected(this.first);
        return this;
    }

    public int getRealMinimum() {
        return this.realmin;
    }

    @Override
    public int getMaximum() {
        return this.realmax - this.realmin + 1;
    }

    @Override
    public int getCountSelected() {
        return 1;
    }

    @Override
    public int getFirstSelected() {
        return this.first;
    }

    @Override
    public void setFirstSelected(int first) {
        this.first = first;
        this.setText(this.getRealValue() + this.suffix);
        this.fireValueEvents(this.getRealValue());
    }

    public ScrollableLabel addValueEvent(ValueEvent event) {
        if (this.valueEvents == null) {
            this.valueEvents = new ArrayList<ValueEvent>();
        }
        this.valueEvents.add(event);
        return this;
    }

    public void removeValueEvent(ValueEvent event) {
        if (this.valueEvents != null) {
            this.valueEvents.remove(event);
        }
    }

    private void fireValueEvents(int value) {
        if (this.valueEvents != null) {
            for (ValueEvent event : this.valueEvents) {
                event.valueChanged(this, value);
            }
        }
    }
}

