/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import mcjty.gui.RenderHelper;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class Button
extends Label<Button> {
    private List<ButtonEvent> buttonEvents = null;
    private boolean pressed = false;

    public Button(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabledAndVisible()) {
            if (this.pressed) {
                RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -10066330, -13421773, -1118482);
            } else {
                RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -1118482, -13421773, -10066330);
            }
        } else {
            RenderHelper.drawBeveledBox(xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, -7829368, -11184811, -10066330);
        }
        super.draw(window, x, y);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            this.pressed = true;
            return this;
        }
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        if (this.pressed) {
            this.pressed = false;
            if (this.isEnabledAndVisible()) {
                this.fireButtonEvents();
            }
        }
    }

    public Button addButtonEvent(ButtonEvent event) {
        if (this.buttonEvents == null) {
            this.buttonEvents = new ArrayList<ButtonEvent>();
        }
        this.buttonEvents.add(event);
        return this;
    }

    public void removeButtonEvent(ButtonEvent event) {
        if (this.buttonEvents != null) {
            this.buttonEvents.remove(event);
        }
    }

    private void fireButtonEvents() {
        if (this.buttonEvents != null) {
            for (ButtonEvent event : this.buttonEvents) {
                event.buttonClicked(this);
            }
        }
    }
}

