/*
 * Decompiled with CFR 0.152.
 */
package mcjty.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.entity.SyncedObject;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.ClientCommandHandler;
import mcjty.rftools.network.CommandHandler;
import mcjty.varia.Coordinate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class GenericTileEntity
extends TileEntity
implements CommandHandler,
ClientCommandHandler {
    private List<SyncedObject> syncedObjects = new ArrayList<SyncedObject>();
    private Coordinate coordinate;
    private int infused = 0;

    public void setInvalid() {
        int newMeta;
        for (SyncedObject value : this.syncedObjects) {
            value.setInvalid();
        }
        int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (oldMeta != (newMeta = this.updateMetaData(oldMeta))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    public void setPowered(int powered) {
    }

    protected void checkStateClient() {
        boolean syncNeeded = false;
        for (SyncedObject value : this.syncedObjects) {
            if (value.isClientValueUptodate()) continue;
            value.updateClientValue();
            syncNeeded = true;
        }
        if (syncNeeded) {
            this.notifyBlockUpdate();
        }
    }

    protected void checkStateServer() {
    }

    protected void notifyBlockUpdate() {
        int newMeta;
        int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (oldMeta != (newMeta = this.updateMetaData(oldMeta))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected int updateMetaData(int meta) {
        return meta;
    }

    protected void registerSyncedObject(SyncedObject value) {
        this.syncedObjects.add(value);
    }

    public boolean canUpdate() {
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void setInfused(int infused) {
        this.infused = infused;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getInfused() {
        return this.infused;
    }

    public float getInfusedFactor() {
        return (float)this.infused / (float)DimletConfiguration.maxInfuse;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        this.infused = tagCompound.func_74762_e("infused");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeRestorableToNBT(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("infused", this.infused);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        return false;
    }

    @Override
    public List executeWithResultList(String command, Map<String, Argument> args) {
        return null;
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        return null;
    }

    @Override
    public boolean execute(String command, List list) {
        return false;
    }

    @Override
    public boolean execute(String command, Integer result) {
        return false;
    }

    public Coordinate getCoordinate() {
        if (this.coordinate == null) {
            this.coordinate = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.coordinate;
    }
}

