/*
 * Decompiled with CFR 0.152.
 */
package mcjty.container;

import java.util.List;
import mcjty.container.ContainerFactory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class InventoryHelper {
    private final TileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private final ItemStack[] stacks;

    public InventoryHelper(TileEntity tileEntity, ContainerFactory containerFactory, int count) {
        this.tileEntity = tileEntity;
        this.containerFactory = containerFactory;
        this.stacks = new ItemStack[count];
    }

    public static int mergeItemStack(IInventory inventory, ItemStack result, int start, int stop, List<SlotModifier> undo) {
        ItemStack itemstack1;
        int k;
        int itemsToPlace = result.field_77994_a;
        if (result.func_77985_e()) {
            for (k = start; itemsToPlace > 0 && k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (itemstack1 == null || itemstack1.func_77973_b() != result.func_77973_b() || result.func_77981_g() && result.func_77960_j() != itemstack1.func_77960_j() || !ItemStack.func_77970_a((ItemStack)result, (ItemStack)itemstack1)) continue;
                int l = itemstack1.field_77994_a + itemsToPlace;
                if (l <= result.func_77976_d()) {
                    if (undo != null) {
                        undo.add(new SlotModifier(k, itemstack1.func_77946_l()));
                    }
                    itemsToPlace = 0;
                    itemstack1.field_77994_a = l;
                    inventory.func_70296_d();
                    continue;
                }
                if (itemstack1.field_77994_a >= result.func_77976_d()) continue;
                if (undo != null) {
                    undo.add(new SlotModifier(k, itemstack1.func_77946_l()));
                }
                itemsToPlace -= result.func_77976_d() - itemstack1.field_77994_a;
                itemstack1.field_77994_a = result.func_77976_d();
                inventory.func_70296_d();
            }
        }
        if (itemsToPlace > 0) {
            for (k = start; k < stop; ++k) {
                itemstack1 = inventory.func_70301_a(k);
                if (itemstack1 != null) continue;
                if (undo != null) {
                    undo.add(new SlotModifier(k, null));
                }
                inventory.func_70299_a(k, result.func_77946_l());
                inventory.func_70296_d();
                itemsToPlace = 0;
                break;
            }
        }
        return itemsToPlace;
    }

    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = this.stacks[index];
            this.stacks[index] = null;
            if (old == null) {
                return null;
            }
            old.field_77994_a = 0;
            return old;
        }
        if (this.stacks[index] != null) {
            if (this.stacks[index].field_77994_a <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = null;
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return null;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (this.containerFactory.isGhostSlot(index)) {
            if (stack != null) {
                this.stacks[index] = stack.func_77946_l();
                if (index < 9) {
                    this.stacks[index].field_77994_a = 1;
                }
            } else {
                this.stacks[index] = null;
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            this.stacks[index] = stack != null ? stack.func_77946_l() : null;
        } else {
            this.stacks[index] = stack;
            if (stack != null && stack.field_77994_a > stackLimit) {
                stack.field_77994_a = stackLimit;
            }
            this.tileEntity.func_70296_d();
        }
    }

    public static class SlotModifier {
        private final int slot;
        private final ItemStack old;

        public SlotModifier(int slot, ItemStack old) {
            this.slot = slot;
            this.old = old;
        }

        public int getSlot() {
            return this.slot;
        }

        public ItemStack getOld() {
            return this.old;
        }
    }
}

