/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tterrag.core.common.util.TTFileUtils;

public class JsonConfigReader<T>
implements Iterable<T> {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final JsonParser parser = new JsonParser();
    private static final String DEFAULT_KEY = "data";
    private File file;
    private JsonObject root;
    private Class<T> type = null;
    private TypeToken<T> typeToken = null;

    public JsonConfigReader(ModToken mod, String fullFileName, Class<T> objClass) {
        this(mod, new File(fullFileName), objClass);
    }

    public JsonConfigReader(ModToken mod, File file, Class<T> objClass) {
        this.type = objClass;
        this.initialize(mod, file);
    }

    public JsonConfigReader(ModToken mod, String fullFileName, TypeToken<T> objType) {
        this(mod, new File(fullFileName), objType);
    }

    public JsonConfigReader(ModToken mod, File file, TypeToken<T> objType) {
        this.typeToken = objType;
        this.initialize(mod, file);
    }

    private void initialize(ModToken mod, File file) {
        this.file = file;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            String assetPath = mod.getAssetPath();
            if (!assetPath.endsWith("/")) {
                assetPath = assetPath + "/";
            }
            TTFileUtils.copyFromJar(mod.getMainClass(), assetPath + file.getName(), file);
        }
        this.refresh();
    }

    public JsonObject parseFile() {
        try {
            return parser.parse((Reader)new FileReader(this.file)).getAsJsonObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void refresh() {
        this.root = this.parseFile();
    }

    public List<T> getElements(String key) {
        JsonArray elements = this.root.get(key).getAsJsonArray();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < elements.size(); ++i) {
            if (this.type == null) {
                list.add(gson.fromJson(elements.get(i), this.typeToken.getType()));
                continue;
            }
            list.add(gson.fromJson(elements.get(i), this.type));
        }
        return list;
    }

    public List<T> getElements() {
        return this.getElements(DEFAULT_KEY);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getElements().iterator();
    }

    public static class ModToken {
        private Class<?> mainClass;
        private String assetPath;

        @ConstructorProperties(value={"mainClass", "assetPath"})
        public ModToken(Class<?> mainClass, String assetPath) {
            this.mainClass = mainClass;
            this.assetPath = assetPath;
        }

        public Class<?> getMainClass() {
            return this.mainClass;
        }

        public String getAssetPath() {
            return this.assetPath;
        }
    }
}

