/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.filter;

import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.IFilterConfig;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class FilterLogicBase
implements IFilterConfig {
    public static final Perm[] levelPerms = new Perm[]{Perm.SERVO, Perm.SERVO, Perm.FILTER};
    public static final int[][] minLevels = new int[][]{{1, 0, 0}, {1, 0, 0}, {1, 0, 0}, {1, 0, 0}, {1, 0, 0}};
    public static final int[][] maxLevels = new int[][]{{ServoItem.maxSize[0], 0, 0}, {ServoItem.maxSize[1], 0, 0}, {ServoItem.maxSize[2], 3, 1}, {ServoItem.maxSize[3], 3, 1}, {ServoItem.maxSize[4], 3, 1}};
    public static final int[] defaultLevels = new int[]{64, 0, 1};
    public int[] validLevels;
    public static final String[] levelNames = new String[]{"stacksize", "routeType", "antiSpam"};
    private final int[] levels = new int[defaultLevels.length];
    public static final int levelStacksize = 0;
    public static final int levelRouteMode = 1;
    public static final int levelConservativeMode = 2;
    public static final int[] maxFilterItems = new int[]{3, 6, 9, 12, 15};
    public static final int[] maxFilterItemWidth = new int[]{3, 3, 3, 4, 5};
    protected static final int flagBlackList = 0;
    protected static final int flagIgnoreMetadata = 1;
    protected static final int flagIgnoreNBT = 2;
    protected static final int flagIgnoreOreDictionary = 3;
    protected static final int flagIgnoreMod = 4;
    public static final String[] flagTypes = new String[]{"whiteList", "metadata", "nbt", "oreDict", "modSorting"};
    protected final ItemStack[] items;
    public boolean recalc = true;
    public final ConnectionBase connection;
    public final int type;
    public static final boolean[] defaultflags = new boolean[]{true, false, false, true, true};
    boolean[] flags = new boolean[]{true, false, false, true, true};
    TIntHashSet oreIds;
    LinkedList<ItemStack> quickItems;
    HashSet<String> modNames;
    HashSet<Fluid> fluidsSimple;
    HashSet<FluidStack> fluidsNBT;
    public static int[] options = new int[]{0, 1, 6, 6, 6};
    protected final Duct.Type transferType;
    protected int[] validFlags;
    public boolean levelsChanged;

    public FilterLogicBase(int n, Duct.Type type, ConnectionBase connectionBase) {
        this.type = n;
        this.transferType = type;
        this.items = new ItemStack[maxFilterItems[n]];
        if (type == Duct.Type.ITEM) {
            this.quickItems = new LinkedList();
        } else if (type == Duct.Type.FLUID) {
            this.fluidsSimple = new HashSet();
            this.fluidsNBT = new HashSet();
        }
        this.connection = connectionBase;
        this.initLevels();
    }

    protected void initLevels() {
        int n;
        TIntArrayList tIntArrayList = new TIntArrayList(this.levels.length);
        for (n = 0; n < this.levels.length; ++n) {
            this.levels[n] = Math.max(Math.min(defaultLevels[n], maxLevels[this.type][n]), minLevels[this.type][n]);
            if (n == 0 || !levelPerms[n].appliesTo(this) || minLevels[this.type][n] >= maxLevels[this.type][n]) continue;
            tIntArrayList.add(n);
        }
        this.validLevels = tIntArrayList.toArray();
        tIntArrayList.clear();
        for (n = 0; n < this.numFlags(); ++n) {
            if (!this.canAlterFlag(n)) continue;
            tIntArrayList.add(n);
        }
        this.validFlags = tIntArrayList.toArray();
    }

    public void incLevel(int n) {
        this.incLevel(n, 1, true);
    }

    public void decLevel(int n) {
        this.decLevel(n, 1, true);
    }

    public void incLevel(int n, int n2, boolean bl) {
        int n3 = this.getLevel(n) + n2;
        if (n3 > maxLevels[this.type][n]) {
            n3 = bl ? minLevels[this.type][n] : maxLevels[this.type][n];
        }
        this.setLevel(n, n3);
    }

    public void decLevel(int n, int n2, boolean bl) {
        int n3 = this.getLevel(n) - n2;
        if (n3 < minLevels[this.type][n]) {
            n3 = bl ? maxLevels[this.type][n] : minLevels[this.type][n];
        }
        this.setLevel(n, n3);
    }

    public void setLevel(int n, int n2) {
        if (n2 < minLevels[this.type][n]) {
            n2 = minLevels[this.type][n];
        }
        if (n2 > maxLevels[this.type][n]) {
            n2 = maxLevels[this.type][n];
        }
        if (this.levels[n] == n2) {
            return;
        }
        if (!levelPerms[n].appliesTo(this)) {
            return;
        }
        if (this.connection.tile.world().field_72995_K) {
            this.connection.sendFilterConfigPacketLevel(n, n2);
        } else {
            this.connection.tile.func_70296_d();
            this.levelsChanged = true;
        }
        this.levels[n] = n2;
    }

    public int getLevel(int n) {
        return this.levels[n];
    }

    @Override
    public ItemStack[] getFilterStacks() {
        return null;
    }

    @Override
    public void onChange() {
    }

    @Override
    public int filterStackGridWidth() {
        return 0;
    }

    @Override
    public boolean getFlag(int n) {
        return false;
    }

    @Override
    public boolean setFlag(int n, boolean bl) {
        return false;
    }

    @Override
    public boolean canAlterFlag(int n) {
        return false;
    }

    @Override
    public String flagType(int n) {
        return null;
    }

    @Override
    public int numFlags() {
        return 0;
    }

    public static enum Perm {
        FILTER(true, false, Duct.Type.ITEM),
        SERVO(false, true, Duct.Type.ITEM),
        ALL(true, true, Duct.Type.ITEM);

        public final boolean filter;
        public final boolean servo;
        public final Duct.Type ductType;

        private Perm(boolean bl, boolean bl2, Duct.Type type) {
            this.filter = bl;
            this.servo = bl2;
            this.ductType = type;
        }

        public boolean appliesTo(FilterLogicBase filterLogicBase) {
            return !(filterLogicBase.transferType != this.ductType || filterLogicBase.connection.getId() == 3 && !this.filter || filterLogicBase.connection.getId() == 4 && !this.filter || filterLogicBase.connection.getId() == 2 && !this.servo || filterLogicBase.connection.getId() == 1 && !this.servo || filterLogicBase.connection.getId() == 6 && !this.servo || filterLogicBase.connection.getId() == 5 && !this.servo);
        }
    }
}

