/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import java.util.LinkedList;

public class PerTickIntAverageCalculator {
    private float lastSecondTotal = 0.0f;
    private int index = 0;
    private final LimitedQueue<Float> secondsCache;

    public PerTickIntAverageCalculator() {
        this(5);
    }

    public PerTickIntAverageCalculator(int numSeconds) {
        this.secondsCache = new LimitedQueue(numSeconds);
    }

    public float getAverage() {
        int numTicks = this.index + this.secondsCache.size() * 20;
        if (numTicks == 0) {
            return 0.0f;
        }
        float totalPower = this.lastSecondTotal;
        for (Float fl : this.secondsCache) {
            totalPower += fl.floatValue();
        }
        return totalPower / (float)numTicks;
    }

    public void tick(int value) {
        this.lastSecondTotal += (float)value;
        ++this.index;
        if (this.index == 20) {
            this.secondsCache.add(Float.valueOf(this.lastSecondTotal));
            this.lastSecondTotal = 0.0f;
            this.index = 0;
        }
    }

    private static class LimitedQueue<E>
    extends LinkedList<E> {
        private final int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E o) {
            super.add(o);
            while (this.size() > this.limit) {
                super.remove();
            }
            return true;
        }
    }
}

