/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.GuiHyperCube;
import crazypants.gui.GuiScrollableList;
import crazypants.render.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;

public class GuiChannelList
extends GuiScrollableList<Channel> {
    private List<Channel> channels = new ArrayList<Channel>();
    private Channel activeChannel;
    private final GuiHyperCube parent;

    public GuiChannelList(GuiHyperCube parent, int width, int height, int originX, int originY) {
        super(width, height, originX, originY, Minecraft.func_71410_x().field_71466_p.field_78288_b + 4);
        this.parent = parent;
    }

    void setChannels(List<Channel> val) {
        if (val == null) {
            this.channels = Collections.emptyList();
        }
        this.channels = val;
    }

    void setActiveChannel(Channel channel) {
        this.activeChannel = channel;
    }

    @Override
    public int getNumElements() {
        return this.isActiveChannelListed() ? this.channels.size() : this.channels.size() + 1;
    }

    @Override
    public Channel getElementAt(int index) {
        if (!this.isActiveChannelListed()) {
            if (index == 0) {
                return this.activeChannel;
            }
            --index;
        }
        if (index < 0 || index >= this.channels.size()) {
            return null;
        }
        return this.channels.get(index);
    }

    protected boolean isActiveChannelListed() {
        return this.activeChannel == null || this.channels.contains(this.activeChannel);
    }

    @Override
    protected boolean elementClicked(int i, boolean flag) {
        return this.getElementAt(i) != null;
    }

    @Override
    protected void drawElement(int index, int xPosition, int yPosition, int rowHeight, Tessellator tessellator) {
        if (index < 0 || index >= this.channels.size()) {
            return;
        }
        Channel c = this.getElementAt(index);
        if (c == null) {
            return;
        }
        int col = ColorUtil.getRGB(Color.white);
        if (c.equals(this.activeChannel)) {
            col = this.isActiveChannelListed() ? ColorUtil.getRGB(Color.cyan) : ColorUtil.getRGB(Color.red);
        }
        this.parent.func_73731_b(this.parent.getFontRenderer(), c.name, xPosition + this.margin, yPosition + this.margin / 2, col);
    }
}

