/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.generator.zombie.BubbleFX;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.GuiZombieGenerator;
import crazypants.enderio.machine.generator.zombie.PacketZombieTank;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.FluidUtil;
import crazypants.util.Lang;
import crazypants.util.Util;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class BlockZombieGenerator
extends AbstractMachineBlock<TileZombieGenerator> {
    public static BlockZombieGenerator create() {
        PacketHandler.INSTANCE.registerMessage(PacketZombieTank.class, PacketZombieTank.class, PacketHandler.nextID(), Side.CLIENT);
        BlockZombieGenerator gen = new BlockZombieGenerator();
        gen.init();
        return gen;
    }

    protected BlockZombieGenerator() {
        super(ModObject.blockZombieGenerator, TileZombieGenerator.class, Material.field_151574_g);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        int filled;
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileZombieGenerator)) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        TileZombieGenerator gen = (TileZombieGenerator)te;
        ItemStack item = entityPlayer.field_71071_by.func_70448_g();
        if (item == null) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        FluidStack fluid = FluidUtil.getFluidFromItem(item);
        if (fluid != null && (filled = gen.fill(ForgeDirection.UP, fluid, false)) >= fluid.amount) {
            gen.fill(ForgeDirection.UP, fluid, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, Util.consumeItem(item));
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerZombieGenerator(player.field_71071_by, (TileZombieGenerator)world.func_147438_o(x, y, z));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiZombieGenerator(player.field_71071_by, (TileZombieGenerator)world.func_147438_o(x, y, z));
    }

    @Override
    protected int getGuiId() {
        return 71;
    }

    public int func_149717_k() {
        return 0;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:stirlingGenFrontOn";
        }
        return "enderio:stirlingGenFrontOff";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntity te;
        if (rand.nextInt(3) == 0 && (te = world.func_147438_o(x, y, z)) instanceof TileZombieGenerator && ((TileZombieGenerator)te).isActive()) {
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float yOffset = 0.1f;
                float zOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                BubbleFX fx = new BubbleFX(world, (float)x + xOffset, (float)y + yOffset, (float)z + zOffset, 0.0, 0.5, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            if (Config.machineSoundsEnabled) {
                float volume = Config.machineSoundVolume * 0.045f;
                world.func_72980_b((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "EnderIO:generator.zombie.bubble", volume, world.field_73012_v.nextFloat() * 0.75f, false);
            }
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileZombieGenerator) {
            tooltip.add(((TileZombieGenerator)te).getFluidStored(ForgeDirection.UNKNOWN) + " " + Lang.localize("fluid.millibucket.abr"));
        }
    }
}

