/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import io.netty.buffer.ByteBuf;

public class PacketNetworkEnergyResponse
implements IMessage,
IMessageHandler<PacketNetworkEnergyResponse, IMessage> {
    private int id;
    private long energyStored;
    private float avChange;

    public PacketNetworkEnergyResponse() {
    }

    public PacketNetworkEnergyResponse(ICapBankNetwork network) {
        this.id = network.getId();
        this.energyStored = network.getEnergyStoredL();
        this.avChange = network.getAverageChangePerTick();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeLong(this.energyStored);
        buf.writeFloat(this.avChange);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.energyStored = buf.readLong();
        this.avChange = buf.readFloat();
    }

    public IMessage onMessage(PacketNetworkEnergyResponse message, MessageContext ctx) {
        ClientNetworkManager.getInstance().updateEnergy(message.id, message.energyStored, message.avChange);
        return null;
    }
}

