/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.PoweredTaskProgress;
import crazypants.enderio.network.MessageTileEntity;
import io.netty.buffer.ByteBuf;

public class PacketCurrentTaskProgress
extends MessageTileEntity<AbstractPoweredTaskEntity>
implements IMessageHandler<PacketCurrentTaskProgress, IMessage> {
    private float progress;

    public PacketCurrentTaskProgress() {
    }

    public PacketCurrentTaskProgress(AbstractPoweredTaskEntity tile) {
        super(tile);
        this.progress = -1.0f;
        if (tile.getCurrentTask() != null) {
            this.progress = tile.getCurrentTask().getProgress();
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.progress);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.progress = buf.readFloat();
    }

    public IMessage onMessage(PacketCurrentTaskProgress message, MessageContext ctx) {
        AbstractPoweredTaskEntity tile = (AbstractPoweredTaskEntity)message.getTileEntity(EnderIO.proxy.getClientWorld());
        if (tile != null) {
            tile.currentTask = message.progress < 0.0f ? null : new PoweredTaskProgress(message.progress);
        }
        return null;
    }
}

