/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.PacketRedstoneMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.IGuiScreen;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class RedstoneModeButton
extends IconButtonEIO {
    private static IconEIO[] ICONS = new IconEIO[]{IconEIO.REDSTONE_MODE_ALWAYS, IconEIO.REDSTONE_MODE_WITH_SIGNAL, IconEIO.REDSTONE_MODE_WITHOUT_SIGNAL, IconEIO.REDSTONE_MODE_NEVER};
    private IRedstoneModeControlable model;
    private RedstoneControlMode curMode;
    private boolean rightMouseDown = false;
    private BlockCoord bc;
    private String tooltipKey = "enderio.gui.tooltip.redstoneControlMode";

    public RedstoneModeButton(IGuiScreen gui, int id, int x, int y, IRedstoneModeControlable model) {
        this(gui, id, x, y, model, null);
    }

    public RedstoneModeButton(IGuiScreen gui, int id, int x, int y, IRedstoneModeControlable model, BlockCoord bc) {
        super(gui, id, x, y, ICONS[model.getRedstoneControlMode().ordinal()]);
        this.model = model;
        this.bc = bc;
        this.curMode = model.getRedstoneControlMode();
        this.setToolTip(Lang.localize("gui.tooltip.redstoneControlMode"), this.curMode.getTooltip());
        this.setIcon(ICONS[this.curMode.ordinal()]);
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int par2, int par3) {
        boolean result = super.func_146116_c(par1Minecraft, par2, par3);
        if (result) {
            this.nextMode();
        }
        return result;
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }

    public void setTooltipKey(String tooltipKey) {
        this.tooltipKey = tooltipKey;
        this.setToolTip(Lang.localize(tooltipKey, false), this.model.getRedstoneControlMode().getTooltip());
    }

    private void nextMode() {
        if (this.curMode == null) {
            this.curMode = RedstoneControlMode.ON;
        }
        this.setMode(this.curMode.next());
    }

    private void prevMode() {
        if (this.curMode == null) {
            this.curMode = RedstoneControlMode.ON;
        }
        this.setMode(this.curMode.previous());
    }

    public void setMode(RedstoneControlMode mode) {
        if (mode == this.curMode) {
            return;
        }
        this.curMode = mode;
        this.setToolTip(Lang.localize(this.tooltipKey, false), mode.getTooltip());
        this.setIcon(ICONS[mode.ordinal()]);
        this.model.setRedstoneControlMode(mode);
        if (this.bc != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneMode(this.model, this.bc.x, this.bc.y, this.bc.z));
        }
    }

    @Override
    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        super.func_146112_a(mc, mouseX, mouseY);
        Rectangle r = new Rectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        if (r.contains(mouseX, mouseY)) {
            if (this.rightMouseDown && Mouse.getEventButton() == 1 && !Mouse.getEventButtonState()) {
                this.prevMode();
                this.gui.doActionPerformed(this);
            }
            this.rightMouseDown = Mouse.getEventButton() == 1 && Mouse.getEventButtonState();
        } else {
            this.rightMouseDown = false;
        }
    }
}

