/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.pixelmon;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonPixelmonTiles
implements IWailaDataProvider {
    public static Class classTileEntityApricornTree = null;
    public static Class classBlockApricornTree = null;
    private static String showApricornGrowth = "wawla.pixelmon.showApricornGrowth";
    private static String showApricornProduct = "wawla.pixelmon.showApricornProduct";

    public AddonPixelmonTiles() {
        if (Loader.isModLoaded((String)"pixelmon")) {
            try {
                classTileEntityApricornTree = Class.forName("com.pixelmonmod.pixelmon.blocks.apricornTrees.TileEntityApricornTree");
                classBlockApricornTree = Class.forName("com.pixelmonmod.pixelmon.blocks.apricornTrees.BlockApricornTree");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        this.createApricornTooltip(data.getTileEntity(), tip, data.getBlock(), cfg);
        this.createApricornTooltip(data.getWorld().func_147438_o(data.getPosition().field_72311_b, data.getPosition().field_72312_c - 1, data.getPosition().field_72309_d), tip, data.getBlock(), cfg);
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonPixelmonTiles dataProvider = new AddonPixelmonTiles();
        register.addConfig("Pixelmon", showApricornGrowth);
        register.addConfig("Pixelmon", showApricornProduct);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, classBlockApricornTree);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, classBlockApricornTree);
    }

    void createApricornTooltip(TileEntity entity, List<String> tip, Block block, IWailaConfigHandler cfg) {
        if (entity != null && Utilities.compareByClass(classTileEntityApricornTree, entity.getClass())) {
            float meta = entity.func_145831_w().func_72805_g(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
            String product = Block.field_149771_c.func_148750_c((Object)block);
            if (cfg.getConfig(showApricornGrowth)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.growth") + ": " + Utilities.round(Utilities.getGrowth(meta, 5.0f), 0) + "%");
            }
            if (cfg.getConfig(showApricornProduct)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.pixelmon.product") + ": " + product.substring(9, product.length() - 5));
            }
        }
    }
}

