/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.generic;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.addons.tinkersconstruct.AddonTinkersTiles;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonGenericTiles
implements IWailaDataProvider {
    private static String showTool = "wawla.harvest.showTool";
    private static String showHarvestable = "wawla.harvest.showHarvest";
    private static String showTier = "wawla.harvest.showTier";
    private static String showDay = "wawla.light.showDay";
    private static String showMonsterSpawn = "wawla.light.monsterSpawn";
    private static String showLightLevel = "wawla.light.lightLevel";

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return data.getStack();
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        int itemLevel;
        MovingObjectPosition pos = data.getPosition();
        Block block = data.getBlock();
        ItemStack item = data.getPlayer().func_70694_bm();
        String tool = block != null ? block.getHarvestTool(data.getMetadata()) : "";
        int blockLevel = block.getHarvestLevel(data.getMetadata());
        int n = itemLevel = item != null ? item.func_77973_b().getHarvestLevel(item, tool) : 0;
        if (tool != null && tool.equalsIgnoreCase("chisel")) {
            if (block == Blocks.field_150348_b) {
                tool = "pickaxe";
            }
            if (block == Blocks.field_150344_f) {
                tool = "axe";
            }
        }
        if (item != null && (item.func_77973_b().getToolClasses(item).contains(tool) || AddonTinkersTiles.canHarvest(item, tool))) {
            if (cfg.getConfig(showHarvestable) && (blockLevel <= itemLevel || blockLevel == 0)) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"tooltip.wawla.yes"));
            } else {
                if (cfg.getConfig(showHarvestable)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.canHarvest") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.wawla.no"));
                }
                if (cfg.getConfig(showTier)) {
                    tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.blockLevel") + ": " + blockLevel);
                }
            }
        }
        if (tool != null && cfg.getConfig(showTool)) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.toolType") + ": " + StatCollector.func_74838_a((String)("tooltip.wawla.tooltype." + tool)));
        }
        if (cfg.getConfig(showLightLevel) && (!data.getWorld().func_147445_c(data.getPosition().field_72311_b, data.getPosition().field_72312_c + 1, data.getPosition().field_72309_d, false) || data.getWorld().func_147437_c(data.getPosition().field_72311_b, data.getPosition().field_72312_c + 1, data.getPosition().field_72309_d))) {
            int dayLevel = Utilities.getBlockLightLevel(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d, true);
            int nightLevel = Utilities.getBlockLightLevel(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d, false);
            String display = StatCollector.func_74838_a((String)"tooltip.wawla.lightLevel") + ": ";
            if (cfg.getConfig(showMonsterSpawn)) {
                if (nightLevel <= 7) {
                    display = display + EnumChatFormatting.DARK_RED + "" + nightLevel + " ";
                } else if (nightLevel > 7) {
                    display = display + EnumChatFormatting.GREEN + "" + nightLevel + " ";
                }
            }
            if (cfg.getConfig(showDay)) {
                display = display + EnumChatFormatting.YELLOW + "(" + dayLevel + ")";
            }
            tip.add(display);
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tip, IWailaDataAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te != null) {
            te.func_145841_b(tag);
        }
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonGenericTiles dataProvider = new AddonGenericTiles();
        register.addConfig("Wawla-General", showTool);
        register.addConfig("Wawla-General", showHarvestable);
        register.addConfig("Wawla-General", showTier);
        register.addConfig("Wawla-General", showLightLevel);
        register.addConfig("Wawla-General", showMonsterSpawn);
        register.addConfig("Wawla-General", showDay);
        register.registerBodyProvider((IWailaDataProvider)dataProvider, Block.class);
        register.registerNBTProvider((IWailaDataProvider)dataProvider, Block.class);
    }
}

