/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc.asm;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.interfaces.oc.asm.ICallerBase;
import openperipheral.interfaces.oc.asm.MethodsStore;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class CommonMethodsBuilder {
    public static final String TARGET_FIELD_NAME = "target";
    public static final String METHODS_FIELD_NAME = "methods";
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final Type EXECUTOR_TYPE = Type.getType(IMethodExecutor.class);
    public static final Type EXECUTORS_TYPE = Type.getType(IMethodExecutor[].class);
    private static final Type OBJECTS_TYPE = Type.getType(Object[].class);
    private static final Type CONTEXT_TYPE = Type.getType(Context.class);
    private static final Type ARGUMENTS_TYPE = Type.getType(Arguments.class);
    private static final Type CALLBACK_TYPE = Type.getType(Callback.class);
    private static final Type METHOD_STORE_TYPE = Type.getType(MethodsStore.class);
    private static final Type BASE_TYPE = Type.getType(ICallerBase.class);
    private static final Type METHOD_STORE_COLLECT_TYPE = Type.getMethodType((Type)EXECUTORS_TYPE, (Type[])new Type[]{Type.INT_TYPE});
    public static final Type WRAP_TYPE = Type.getMethodType((Type)OBJECTS_TYPE, (Type[])new Type[]{CONTEXT_TYPE, ARGUMENTS_TYPE});
    public static final Type CALLER_METHOD_TYPE = Type.getMethodType((Type)OBJECTS_TYPE, (Type[])new Type[]{OBJECT_TYPE, EXECUTOR_TYPE, CONTEXT_TYPE, ARGUMENTS_TYPE});
    private static final Type INVALID_STATE_TYPE = Type.getMethodType((Type)OBJECTS_TYPE, (Type[])new Type[0]);
    private static final Type CLINIT_TYPE = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private final ClassWriter writer;
    private final String clsName;
    private final Type targetType;

    public CommonMethodsBuilder(ClassWriter writer, String clsName, Type targetType) {
        this.writer = writer;
        this.clsName = clsName;
        this.targetType = targetType;
    }

    private static void visitIntConst(MethodVisitor mv, int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(3 + value);
                break;
            }
            default: {
                mv.visitLdcInsn((Object)value);
            }
        }
    }

    public void addMethodsField() {
        this.writer.visitField(10, METHODS_FIELD_NAME, EXECUTORS_TYPE.getDescriptor(), null, null);
    }

    public void addTargetField() {
        this.writer.visitField(18, TARGET_FIELD_NAME, this.targetType.getDescriptor(), null, null);
    }

    public void createScriptMethodWrapper(String methodName, int methodIndex, IMethodExecutor executor) {
        String generatedMethodName = methodName.replaceAll("[^A-Za-z0-9_]", "_") + "$" + Integer.toString(methodIndex);
        MethodVisitor wrap = this.writer.visitMethod(4097, generatedMethodName, WRAP_TYPE.getDescriptor(), null, null);
        AnnotationVisitor av = wrap.visitAnnotation(CALLBACK_TYPE.getDescriptor(), true);
        av.visit("value", (Object)methodName);
        av.visit("direct", (Object)executor.isAsynchronous());
        av.visit("doc", (Object)executor.description().doc());
        av.visitEnd();
        av.visitEnd();
        wrap.visitCode();
        wrap.visitVarInsn(25, 0);
        wrap.visitInsn(89);
        wrap.visitFieldInsn(180, this.clsName, TARGET_FIELD_NAME, this.targetType.getDescriptor());
        Label skip = new Label();
        wrap.visitInsn(89);
        wrap.visitJumpInsn(199, skip);
        wrap.visitInsn(87);
        wrap.visitMethodInsn(185, BASE_TYPE.getInternalName(), "invalidState", INVALID_STATE_TYPE.getDescriptor());
        wrap.visitInsn(176);
        wrap.visitLabel(skip);
        wrap.visitFieldInsn(178, this.clsName, METHODS_FIELD_NAME, EXECUTORS_TYPE.getDescriptor());
        CommonMethodsBuilder.visitIntConst(wrap, methodIndex);
        wrap.visitInsn(50);
        wrap.visitVarInsn(25, 1);
        wrap.visitVarInsn(25, 2);
        wrap.visitMethodInsn(185, BASE_TYPE.getInternalName(), "call", CALLER_METHOD_TYPE.getDescriptor());
        wrap.visitInsn(176);
        wrap.visitMaxs(0, 0);
        wrap.visitEnd();
    }

    public void addExposedMethodBypass(Method method, Type sourceInterface) {
        MethodVisitor mv = this.writer.visitMethod(4097, method.getName(), method.getDescriptor(), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.clsName, TARGET_FIELD_NAME, this.targetType.getDescriptor());
        Type[] args = method.getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            mv.visitVarInsn(args[i].getOpcode(21), i + 1);
        }
        mv.visitMethodInsn(185, sourceInterface.getInternalName(), method.getName(), method.getDescriptor());
        Type returnType = method.getReturnType();
        mv.visitInsn(returnType.getOpcode(172));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void addClassInit(int methodsDropboxId) {
        MethodVisitor mv = this.writer.visitMethod(4105, "<clinit>", CLINIT_TYPE.getDescriptor(), null, null);
        mv.visitCode();
        CommonMethodsBuilder.visitIntConst(mv, methodsDropboxId);
        mv.visitMethodInsn(184, METHOD_STORE_TYPE.getInternalName(), "collect", METHOD_STORE_COLLECT_TYPE.getDescriptor());
        mv.visitFieldInsn(179, this.clsName, METHODS_FIELD_NAME, EXECUTORS_TYPE.getDescriptor());
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

