/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import openperipheral.adapter.IMethodCall;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.TypeConvertersProvider;
import openperipheral.interfaces.cc.wrappers.LuaObjectWrapper;

public class ComputerCraftEnv {
    public static IArchitectureAccess createAccess(final IComputerAccess access) {
        return new IArchitectureAccess(){

            @Override
            public String architecture() {
                return "ComputerCraft";
            }

            @Override
            public String callerName() {
                return Integer.toString(access.getID());
            }

            @Override
            public String peripheralName() {
                return access.getAttachmentName();
            }

            @Override
            public boolean signal(String name, Object ... args) {
                access.queueEvent(name, args);
                return true;
            }

            @Override
            public Object wrapObject(Object target) {
                return LuaObjectWrapper.wrap(target);
            }
        };
    }

    public static IMethodCall addCommonArgs(IMethodCall call, ILuaContext context) {
        IConverter converter = TypeConvertersProvider.INSTANCE.getConverter("ComputerCraft");
        return call.setOptionalArg("converter", converter).setOptionalArg("context", context);
    }

    public static IMethodCall addPeripheralArgs(IMethodCall call, IComputerAccess access, ILuaContext context) {
        IArchitectureAccess wrappedAccess = ComputerCraftEnv.createAccess(access);
        return ComputerCraftEnv.addCommonArgs(call, context).setOptionalArg("access", wrappedAccess).setOptionalArg("computer", access);
    }
}

