/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.method;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.converter.IConverter;

public class Argument {
    public final String name;
    public final String description;
    public final ArgType luaType;
    public final TypeToken<?> javaType;
    final int javaArgIndex;

    public Argument(String name, String description, ArgType luaType, TypeToken<?> javaType, int javaArgIndex) {
        this.name = name;
        this.description = description;
        this.luaType = luaType;
        this.javaArgIndex = javaArgIndex;
        this.javaType = this.getArgType(javaType);
    }

    protected TypeToken<?> getArgType(TypeToken<?> javaArgClass) {
        return javaArgClass;
    }

    public Object convert(IConverter converter, Iterator<Object> args) {
        Preconditions.checkArgument((boolean)args.hasNext(), (String)"Not enough arguments, first missing: %s", (Object[])new Object[]{this.name});
        Object arg = args.next();
        Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (String)"Argument %s cannot be null", (Object[])new Object[]{this.name});
        return this.convertSingleArg(converter, arg);
    }

    protected final Object convertSingleArg(IConverter converter, Object o) {
        try {
            return converter.toJava(o, this.javaType.getType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to convert arg '%s'", this.name), e);
        }
    }

    public Map<String, Object> describe() {
        HashMap result = Maps.newHashMap();
        result.put("type", this.luaType.toString());
        result.put("name", this.name);
        result.put("description", this.description);
        return result;
    }

    public String toString() {
        return this.name;
    }

    public String doc() {
        return this.luaType.getName();
    }
}

