/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openperipheral.adapter.AdapterRegistry;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.ClassMethodsComposer;
import openperipheral.adapter.composed.IMethodMap;

public abstract class ComposedMethodsFactory<T extends IMethodMap> {
    private final Map<Class<?>, T> classes = Maps.newHashMap();
    private final Set<Class<?>> invalidClasses = Sets.newHashSet();
    private final AdapterRegistry adapters;
    private final ClassMethodsComposer composer;

    public ComposedMethodsFactory(AdapterRegistry adapters, Predicate<IMethodExecutor> selector) {
        this.adapters = adapters;
        this.composer = new ClassMethodsComposer(selector);
    }

    public Map<Class<?>, T> listCollectedClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    public T getAdaptedClass(Class<?> targetCls) {
        if (this.invalidClasses.contains(targetCls)) {
            throw new InvalidClassException();
        }
        IMethodMap value = (IMethodMap)this.classes.get(targetCls);
        if (value == null) {
            try {
                Map<String, IMethodExecutor> methods = this.composer.createMethodsList(targetCls, this.adapters);
                value = this.wrapMethods(targetCls, methods);
            }
            catch (Throwable t) {
                this.invalidClasses.add(targetCls);
                throw new InvalidClassException(t);
            }
            this.classes.put(targetCls, value);
        }
        return (T)value;
    }

    protected abstract T wrapMethods(Class<?> var1, Map<String, IMethodExecutor> var2);

    public static class InvalidClassException
    extends RuntimeException {
        private static final long serialVersionUID = 5722017683388067641L;

        private InvalidClassException() {
        }

        private InvalidClassException(Throwable cause) {
            super(cause);
        }
    }
}

