/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import openmods.config.properties.ConfigProcessing;
import openperipheral.ApiProvider;
import openperipheral.CommandDump;
import openperipheral.Config;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.api.peripheral.IOpenPeripheral;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.oc.ModuleOpenComputers;

@Mod(modid="OpenPeripheralCore", name="OpenPeripheralCore", version="1.1", dependencies="required-after:OpenMods@[0.7,0.8);after:ComputerCraft@[1.70,];after:OpenComputers@[1.5.0,];", acceptableRemoteVersions="*")
public class OpenPeripheralCore {
    public static final String PROVIDED_API_VERSION = "3.2";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        File configFile = evt.getSuggestedConfigurationFile();
        Configuration config = new Configuration(configFile);
        ConfigProcessing.processAnnotations((String)"OpenPeripheralCore", (Configuration)config, Config.class);
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)TileEntityBlacklist.INSTANCE);
        FMLInterModComms.sendMessage((String)"OpenComputers", (String)"blacklistPeripheral", (String)IOpenPeripheral.class.getName());
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ModuleOpenComputers.init();
        }
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModuleComputerCraft.init();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ModuleOpenComputers.registerProvider();
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent evt) {
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModuleComputerCraft.registerProvider();
        }
    }

    @Mod.EventHandler
    public void processMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!m.isStringMessage() || !"ignoreTileEntity".equalsIgnoreCase(m.key)) continue;
            TileEntityBlacklist.INSTANCE.addToBlacklist(m.getStringValue());
        }
    }

    @Mod.EventHandler
    public void severStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandDump("op_dump", evt.getServer().func_71262_S()));
    }

    static {
        ApiProvider.installApi();
    }
}

