/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class UtilItemModular {
    public static boolean moduleTypeEquals(ItemStack moduleStack, ItemModule.ModuleType moduleType) {
        return moduleStack != null && moduleStack.func_77973_b() instanceof IModule && ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(moduleType);
    }

    public static NBTTagList getInstalledModules(ItemStack toolStack) {
        if (toolStack == null || !(toolStack.func_77973_b() instanceof IModular)) {
            return null;
        }
        NBTTagCompound nbt = toolStack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Items", 9)) {
            return null;
        }
        return nbt.func_150295_c("Items", 10);
    }

    public static int getModuleCount(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        NBTTagList nbtTagList = UtilItemModular.getInstalledModules(toolStack);
        if (nbtTagList == null) {
            return 0;
        }
        int count = 0;
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            if (!UtilItemModular.moduleTypeEquals(moduleStack, moduleType)) continue;
            ++count;
        }
        return count;
    }

    public static int getMaxModuleTier(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        int tier = -1;
        NBTTagList nbtTagList = UtilItemModular.getInstalledModules(toolStack);
        if (nbtTagList == null) {
            return tier;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        for (int i = 0; i < listNumStacks; ++i) {
            int t;
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            if (!UtilItemModular.moduleTypeEquals(moduleStack, moduleType) || (t = ((IModule)moduleStack.func_77973_b()).getModuleTier(moduleStack)) <= tier) continue;
            tier = t;
        }
        return tier;
    }

    public static int getSelectedModuleTier(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return -1;
        }
        return ((IModule)moduleStack.func_77973_b()).getModuleTier(moduleStack);
    }

    public static int getClampedModuleSelection(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        int num;
        if (toolStack == null || toolStack.func_77978_p() == null) {
            return 0;
        }
        int selected = toolStack.func_77978_p().func_74771_c("Selected_" + moduleType.getName());
        if (selected >= (num = UtilItemModular.getModuleCount(toolStack, moduleType))) {
            selected = num > 0 ? num - 1 : 0;
        }
        return selected;
    }

    public static NBTTagCompound getSelectedModuleTagCompound(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        NBTTagList nbtTagList = UtilItemModular.getInstalledModules(toolStack);
        if (nbtTagList == null) {
            return null;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        int selected = UtilItemModular.getClampedModuleSelection(toolStack, moduleType);
        int count = -1;
        for (int i = 0; i < listNumStacks && count < selected; ++i) {
            NBTTagCompound moduleTag = nbtTagList.func_150305_b(i);
            ItemStack moduleStack = ItemStack.func_77949_a((NBTTagCompound)moduleTag);
            if (!UtilItemModular.moduleTypeEquals(moduleStack, moduleType) || ++count < selected) continue;
            return moduleTag;
        }
        return null;
    }

    public static ItemStack getSelectedModuleStack(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        NBTTagCompound tag = UtilItemModular.getSelectedModuleTagCompound(toolStack, moduleType);
        if (tag != null) {
            return ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        return null;
    }

    public static ItemStack setSelectedModuleStack(ItemStack toolStack, ItemModule.ModuleType moduleType, ItemStack newModuleStack) {
        NBTTagList nbtTagList = UtilItemModular.getInstalledModules(toolStack);
        if (nbtTagList == null) {
            return null;
        }
        NBTTagCompound nbt = toolStack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        int listNumStacks = nbtTagList.func_74745_c();
        int selected = UtilItemModular.getClampedModuleSelection(toolStack, moduleType);
        int count = -1;
        for (int i = 0; i < listNumStacks && count < selected; ++i) {
            NBTTagCompound moduleTag = nbtTagList.func_150305_b(i);
            if (!UtilItemModular.moduleTypeEquals(ItemStack.func_77949_a((NBTTagCompound)moduleTag), moduleType) || ++count < selected) continue;
            nbtTagList.func_150304_a(i, (NBTBase)newModuleStack.func_77955_b(moduleTag));
            return toolStack;
        }
        return toolStack;
    }

    public static List<NBTTagCompound> getAllModules(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return null;
    }

    public static ItemStack setAllModules(ItemStack stack, List<NBTTagCompound> modules) {
        if (stack == null) {
            return null;
        }
        return stack;
    }

    public static ItemStack setModule(ItemStack stack, int index, NBTTagCompound nbt) {
        if (stack == null) {
            return null;
        }
        return stack;
    }

    public static ItemStack changeSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, boolean reverse) {
        int moduleCount = UtilItemModular.getModuleCount(toolStack, moduleType);
        NBTTagCompound nbt = toolStack.func_77978_p();
        if (moduleCount == 0 || nbt == null) {
            return toolStack;
        }
        int selected = UtilItemModular.getClampedModuleSelection(toolStack, moduleType);
        if (reverse) {
            if (--selected < 0) {
                selected = moduleCount - 1;
            }
        } else if (++selected >= moduleCount) {
            selected = 0;
        }
        nbt.func_74774_a("Selected_" + moduleType.getName(), (byte)selected);
        return toolStack;
    }

    public static boolean useEnderCharge(ItemStack stack, int amount, boolean doUse) {
        if (!Configs.valueUseEnderCharge) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof IModular)) {
            return false;
        }
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof ItemEnderCapacitor)) {
            return false;
        }
        ItemEnderCapacitor cap = (ItemEnderCapacitor)moduleStack.func_77973_b();
        if (cap.useCharge(moduleStack, amount, false) < amount) {
            return false;
        }
        if (doUse) {
            cap.useCharge(moduleStack, amount, true);
            UtilItemModular.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR, moduleStack);
        }
        return true;
    }

    public static boolean useEnderCharge(ItemStack stack, EntityPlayer player, int amount, boolean doUse) {
        if (!Configs.valueUseEnderCharge || player != null && player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return UtilItemModular.useEnderCharge(stack, amount, doUse);
    }

    public static void setTarget(ItemStack toolStack, EntityPlayer player, boolean storeRotation) {
        if (!NBTHelperPlayer.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return;
        }
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        double hitX = player.field_70165_t - (double)x;
        double hitY = player.field_70163_u - (double)y;
        double hitZ = player.field_70161_v - (double)z;
        boolean adjustPosHit = UtilItemModular.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0;
        UtilItemModular.setTarget(toolStack, player, x, y, z, ForgeDirection.UP.ordinal(), hitX, hitY, hitZ, adjustPosHit, storeRotation);
    }

    public static void setTarget(ItemStack toolStack, EntityPlayer player, int x, int y, int z, int side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        NBTHelperTarget.writeTargetTagToSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, x, y, z, player.field_71093_bK, side, hitX, hitY, hitZ, doHitOffset, player.field_70177_z, player.field_70125_A, storeRotation);
        if (!NBTHelperPlayer.selectedModuleHasPlayerTag(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            NBTHelperPlayer.writePlayerTagToSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player, true);
        }
    }
}

