/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderInfuser;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.inventory.ContainerEnderInfuser;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityEnderInfuser
extends TileEntityEnderUtilitiesSided {
    protected static final int[] SLOTS_SIDES = new int[]{0, 1, 2};
    public static final int AMOUNT_PER_ENDERPEARL = 250;
    public static final int AMOUNT_PER_ENDEREYE = 500;
    public static final int ENDER_CHARGE_PER_MILLIBUCKET = 4;
    public static final int MAX_AMOUNT = 4000;
    public int amountStored;
    public int meltingProgress;
    public boolean isCharging;
    public int chargeableItemCapacity;
    public int chargeableItemStartingCharge;
    public int chargeableItemCurrentCharge;

    public TileEntityEnderInfuser() {
        super("enderinfuser");
        this.itemStacks = new ItemStack[3];
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        if (nbt.func_150297_b("Fluid", 10)) {
            this.amountStored = nbt.func_74775_l("Fluid").func_74762_e("Amount");
        }
        this.meltingProgress = nbt.func_74771_c("Progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Amount", this.amountStored);
        tag.func_74778_a("FluidName", "ender");
        nbt.func_74782_a("Fluid", (NBTBase)tag);
        nbt.func_74774_a("Progress", (byte)this.meltingProgress);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean dirty = false;
        boolean sync = false;
        if (this.itemStacks[0] != null) {
            int amount = 0;
            if (this.itemStacks[0].func_77973_b() == Items.field_151079_bi) {
                amount = 250;
            } else if (this.itemStacks[0].func_77973_b() == Items.field_151061_bv) {
                amount = 500;
            }
            if (amount > 0 && amount + this.amountStored <= 4000) {
                this.meltingProgress += 2;
                if (this.meltingProgress >= 100) {
                    this.amountStored += amount;
                    this.meltingProgress = 0;
                    if (--this.itemStacks[0].field_77994_a <= 0) {
                        this.itemStacks[0] = null;
                    }
                }
                dirty = true;
                sync = true;
            }
        } else {
            this.meltingProgress = 0;
        }
        if (this.itemStacks[1] != null && (this.itemStacks[1].func_77973_b() instanceof IChargeable || this.itemStacks[1].func_77973_b() instanceof IModular)) {
            int charge;
            int filled;
            IChargeable item;
            boolean isModular = false;
            ItemStack capacitorStack = this.itemStacks[1];
            if (this.itemStacks[1].func_77973_b() instanceof IChargeable) {
                item = (IChargeable)capacitorStack.func_77973_b();
            } else if (this.itemStacks[1].func_77973_b() instanceof IModular) {
                capacitorStack = UtilItemModular.getSelectedModuleStack(this.itemStacks[1], ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
                if (capacitorStack == null || !(capacitorStack.func_77973_b() instanceof IChargeable)) {
                    return;
                }
                item = (IChargeable)capacitorStack.func_77973_b();
                isModular = true;
            } else {
                return;
            }
            if (this.amountStored > 0 && (filled = item.addCharge(capacitorStack, charge = (this.amountStored >= 10 ? 10 : this.amountStored) * 4, false)) > 0) {
                if (!this.isCharging) {
                    this.chargeableItemCapacity = item.getCapacity(capacitorStack);
                    this.chargeableItemCurrentCharge = this.chargeableItemStartingCharge = item.getCharge(capacitorStack);
                    this.isCharging = true;
                }
                if (filled < charge) {
                    charge = filled;
                }
                charge = item.addCharge(capacitorStack, charge, true);
                int used = (int)Math.ceil(charge / 4);
                this.amountStored -= used;
                this.chargeableItemCurrentCharge += charge;
                dirty = true;
                if (isModular) {
                    UtilItemModular.setSelectedModuleStack(this.itemStacks[1], ItemModule.ModuleType.TYPE_ENDERCAPACITOR, capacitorStack);
                }
            }
            if (item.getCharge(capacitorStack) >= item.getCapacity(capacitorStack)) {
                this.isCharging = false;
                this.chargeableItemCurrentCharge = 0;
                this.chargeableItemStartingCharge = 0;
                this.chargeableItemCapacity = 0;
                if (this.itemStacks[2] == null) {
                    this.itemStacks[2] = this.itemStacks[1];
                    this.itemStacks[1] = null;
                    dirty = true;
                }
            }
        } else {
            this.isCharging = false;
            this.chargeableItemCurrentCharge = 0;
            this.chargeableItemStartingCharge = 0;
            this.chargeableItemCapacity = 0;
        }
        if (dirty) {
            this.func_70296_d();
        }
        if (sync) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        Item item = stack.func_77973_b();
        if (slotNum == 0) {
            return item == Items.field_151079_bi || item == Items.field_151061_bv;
        }
        if (slotNum == 1) {
            return item instanceof IChargeable || item instanceof IModular && ((IModular)item).getModuleCount(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR) > 0;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return SLOTS_SIDES;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    @Override
    public ContainerEnderInfuser getContainer(InventoryPlayer inventory) {
        return new ContainerEnderInfuser(this, inventory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilitiesInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiEnderInfuser(this.getContainer(inventoryPlayer), this);
    }
}

