/*
 * Decompiled with CFR 0.152.
 */
package openmods.stencil;

import openmods.Log;
import openmods.api.IResultListener;
import openmods.asm.MappedType;
import openmods.asm.MethodMatcher;
import openmods.stencil.FramebufferHooks;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class FramebufferInjector
extends ClassVisitor {
    private static final MappedType openGlHelper = MappedType.of("net/minecraft/client/renderer/OpenGlHelper");
    private static final MethodMatcher createRenderbufferMatcher;
    private final MethodMatcher targetMethod;
    private static final Type hookType;
    private final String className;
    private final IResultListener listener;

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.targetMethod.match(name, desc) ? new CreateFramebufferInjector(parent) : parent;
    }

    public FramebufferInjector(String rawCls, ClassVisitor cv, IResultListener listener) {
        super(262144, cv);
        this.listener = listener;
        this.className = rawCls.replace('.', '/');
        Type targetType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE});
        this.targetMethod = new MethodMatcher(rawCls, targetType.getDescriptor(), "createFramebuffer", "func_147605_b");
    }

    static {
        hookType = Type.getType(FramebufferHooks.class);
        Type createRenderbufferType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE});
        createRenderbufferMatcher = new MethodMatcher(openGlHelper, createRenderbufferType.getDescriptor(), "func_153186_a", "func_153186_a");
    }

    private class CreateFramebufferInjector
    extends MethodVisitor {
        private final Type ownerType;
        private boolean constantFound;

        public CreateFramebufferInjector(MethodVisitor mv) {
            super(262144, mv);
            this.ownerType = Type.getObjectType((String)FramebufferInjector.this.className);
        }

        public void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            if (cst instanceof Number && ((Number)cst).intValue() == 33190) {
                Log.debug("Found GL constant, replacing method", new Object[0]);
                this.constantFound = true;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.constantFound && opcode == 184 && createRenderbufferMatcher.match(name, desc)) {
                Log.debug("Injecting allocate and attach methods", new Object[0]);
                super.visitMethodInsn(184, hookType.getInternalName(), "createRenderbufferStorage", desc);
                super.visitVarInsn(25, 0);
                Type methodType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{this.ownerType});
                super.visitMethodInsn(184, hookType.getInternalName(), "attachRenderbuffer", methodType.getDescriptor());
                FramebufferInjector.this.listener.onSuccess();
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
            this.constantFound = false;
        }
    }
}

