/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import openmods.gui.component.BaseComponent;

public abstract class BaseComposite
extends BaseComponent {
    protected final List<BaseComponent> components = Lists.newArrayList();

    public BaseComposite(int x, int y) {
        super(x, y);
    }

    protected boolean areChildrenActive() {
        return true;
    }

    public BaseComposite addComponent(BaseComponent component) {
        this.components.add(component);
        return this;
    }

    private static boolean isComponentEnabled(BaseComponent component) {
        return component != null && component.isEnabled();
    }

    private static boolean isComponentCapturingMouse(BaseComponent component, int mouseX, int mouseY) {
        return BaseComposite.isComponentEnabled(component) && component.isMouseOver(mouseX, mouseY);
    }

    protected abstract void renderComponentBackground(Minecraft var1, int var2, int var3, int var4, int var5);

    protected void renderComponentForeground(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    @Override
    public final void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.renderComponentBackground(minecraft, offsetX, offsetY, mouseX, mouseY);
        if (!this.areChildrenActive()) {
            return;
        }
        int ownX = offsetX + this.x;
        int ownY = offsetY + this.y;
        int relMouseX = mouseX - this.x;
        int relMouseY = mouseY - this.y;
        for (BaseComponent component : this.components) {
            if (!BaseComposite.isComponentEnabled(component)) continue;
            component.render(minecraft, ownX, ownY, relMouseX, relMouseY);
        }
        this.renderComponentForeground(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    protected void renderComponentOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    @Override
    public final void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.renderComponentOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
        if (!this.areChildrenActive()) {
            return;
        }
        int ownX = offsetX + this.x;
        int ownY = offsetY + this.y;
        int relMouseX = mouseX - this.x;
        int relMouseY = mouseY - this.y;
        for (BaseComponent component : this.components) {
            if (!BaseComposite.isComponentEnabled(component)) continue;
            component.renderOverlay(minecraft, ownX, ownY, relMouseX, relMouseY);
        }
    }

    @Override
    public void keyTyped(char keyChar, int keyCode) {
        super.keyTyped(keyChar, keyCode);
        if (!this.areChildrenActive()) {
            return;
        }
        for (BaseComponent component : this.components) {
            if (!BaseComposite.isComponentEnabled(component)) continue;
            component.keyTyped(keyChar, keyCode);
        }
    }

    private List<BaseComponent> selectComponentsCapturingMouse(int mouseX, int mouseY) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (BaseComponent component : this.components) {
            if (!BaseComposite.isComponentCapturingMouse(component, mouseX, mouseY)) continue;
            result.add((Object)component);
        }
        return result.build();
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        super.mouseDown(mouseX, mouseY, button);
        if (!this.areChildrenActive()) {
            return;
        }
        for (BaseComponent component : this.selectComponentsCapturingMouse(mouseX, mouseY)) {
            component.mouseDown(mouseX - component.x, mouseY - component.y, button);
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        super.mouseUp(mouseX, mouseY, button);
        if (!this.areChildrenActive()) {
            return;
        }
        for (BaseComponent component : this.selectComponentsCapturingMouse(mouseX, mouseY)) {
            component.mouseUp(mouseX - component.x, mouseY - component.y, button);
        }
    }

    @Override
    public void mouseDrag(int mouseX, int mouseY, int button, long time) {
        super.mouseDrag(mouseX, mouseY, button, time);
        if (!this.areChildrenActive()) {
            return;
        }
        for (BaseComponent component : this.selectComponentsCapturingMouse(mouseX, mouseY)) {
            component.mouseDrag(mouseX - component.x, mouseY - component.y, button, time);
        }
    }
}

