/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util;

import cofh.thermalexpansion.block.TileReconfigurable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ReconfigurableHelper {
    public static final byte DEFAULT_FACING = 3;
    public static final byte[] DEFAULT_SIDES = new byte[]{0, 0, 0, 0, 0, 0};

    private ReconfigurableHelper() {
    }

    public static NBTTagCompound setItemStackTagReconfig(NBTTagCompound nBTTagCompound, TileReconfigurable tileReconfigurable) {
        if (tileReconfigurable == null) {
            return null;
        }
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        nBTTagCompound.func_74774_a("Facing", (byte)tileReconfigurable.getFacing());
        nBTTagCompound.func_74773_a("SideCache", tileReconfigurable.sideCache);
        return nBTTagCompound;
    }

    public static byte getFacingFromNBT(NBTTagCompound nBTTagCompound) {
        return !nBTTagCompound.func_74764_b("Facing") ? (byte)3 : nBTTagCompound.func_74771_c("Facing");
    }

    public static byte[] getSideCacheFromNBT(NBTTagCompound nBTTagCompound, byte[] byArray) {
        if (nBTTagCompound == null) {
            return (byte[])byArray.clone();
        }
        byte[] byArray2 = nBTTagCompound.func_74770_j("SideCache");
        return byArray2.length < 6 ? (byte[])byArray.clone() : byArray2;
    }

    public static boolean hasReconfigInfo(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74764_b("Facing") && itemStack.field_77990_d.func_74764_b("SideCache");
    }

    public static boolean setFacing(ItemStack itemStack, int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74774_a("Facing", (byte)n);
        return true;
    }

    public static boolean setSideCache(ItemStack itemStack, byte[] byArray) {
        if (byArray.length < 6) {
            return false;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74773_a("SideCache", byArray);
        return true;
    }

    public static byte getFacing(ItemStack itemStack) {
        return itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("Facing") ? (byte)3 : itemStack.field_77990_d.func_74771_c("Facing");
    }

    public static byte[] getSideCache(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return (byte[])DEFAULT_SIDES.clone();
        }
        byte[] byArray = itemStack.field_77990_d.func_74770_j("SideCache");
        return byArray.length < 6 ? (byte[])DEFAULT_SIDES.clone() : byArray;
    }

    public static byte[] getSideCache(ItemStack itemStack, byte[] byArray) {
        if (itemStack.field_77990_d == null) {
            return (byte[])byArray.clone();
        }
        byte[] byArray2 = itemStack.field_77990_d.func_74770_j("SideCache");
        return byArray2.length < 6 ? (byte[])byArray.clone() : byArray2;
    }
}

