/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.render.IconRegistry;
import cofh.core.util.crafting.RecipeAugmentable;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.dynamo.ItemBlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.block.dynamo.TileDynamoEnervation;
import cofh.thermalexpansion.block.dynamo.TileDynamoMagmatic;
import cofh.thermalexpansion.block.dynamo.TileDynamoReactant;
import cofh.thermalexpansion.block.dynamo.TileDynamoSteam;
import cofh.thermalexpansion.core.TEProps;
import cofh.thermalexpansion.item.TEAugments;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockDynamo
extends BlockTEBase {
    static AxisAlignedBB[] boundingBox;
    public static final String[] NAMES;
    public static boolean[] enable;
    public static ItemStack[] defaultAugments;
    public static boolean defaultRedstoneControl;
    public static ItemStack dynamoSteam;
    public static ItemStack dynamoMagmatic;
    public static ItemStack dynamoCompression;
    public static ItemStack dynamoReactant;
    public static ItemStack dynamoEnervation;

    public BlockDynamo() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.dynamo");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case STEAM: {
                return new TileDynamoSteam();
            }
            case MAGMATIC: {
                return new TileDynamoMagmatic();
            }
            case COMPRESSION: {
                return new TileDynamoCompression();
            }
            case REACTANT: {
                return new TileDynamoReactant();
            }
            case ENERVATION: {
                return new TileDynamoEnervation();
            }
        }
        return null;
    }

    public void func_149743_a(World world, int n, int n2, int n3, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        byte by = ((TileDynamoBase)world.func_147438_o((int)n, (int)n2, (int)n3)).facing;
        AxisAlignedBB axisAlignedBB2 = boundingBox[by].func_72329_c().func_72317_d((double)n, (double)n2, (double)n3);
        AxisAlignedBB axisAlignedBB3 = boundingBox[by + 6].func_72329_c().func_72317_d((double)n, (double)n2, (double)n3);
        if (axisAlignedBB3.func_72326_a(axisAlignedBB)) {
            list.add(axisAlignedBB3);
        }
        if (axisAlignedBB2.func_72326_a(axisAlignedBB)) {
            list.add(axisAlignedBB2);
        }
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            list.add(ItemBlockDynamo.setDefaultTag(new ItemStack(item, 1, i)));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileDynamoBase tileDynamoBase = (TileDynamoBase)world.func_147438_o(n, n2, n3);
        if (itemStack.field_77990_d != null) {
            tileDynamoBase.readAugmentsFromNBT(itemStack.field_77990_d);
            tileDynamoBase.installAugments();
            tileDynamoBase.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    @Override
    public boolean func_149727_a(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4, float f, float f2, float f3) {
        TileDynamoBase tileDynamoBase = (TileDynamoBase)world.func_147438_o(n, n2, n3);
        if (tileDynamoBase instanceof IFluidHandler && FluidHelper.fillHandlerWithContainer((World)world, (IFluidHandler)((IFluidHandler)tileDynamoBase), (EntityPlayer)entityPlayer)) {
            return true;
        }
        return super.func_149727_a(world, n, n2, n3, entityPlayer, n4, f, f2, f3);
    }

    public int func_149701_w() {
        return 0;
    }

    public int func_149645_b() {
        return TEProps.renderIdDynamo;
    }

    public boolean func_149740_M() {
        return true;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (!(tileEntity instanceof TileDynamoBase)) {
            return false;
        }
        TileDynamoBase tileDynamoBase = (TileDynamoBase)tileEntity;
        return tileDynamoBase.facing == BlockHelper.SIDE_OPPOSITE[forgeDirection.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"DynamoCoilRedstone", (String)"thermalexpansion:dynamo/Dynamo_Coil_Redstone", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)("Dynamo" + Types.STEAM.ordinal()), (String)"thermalexpansion:dynamo/Dynamo_Steam", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)("Dynamo" + Types.MAGMATIC.ordinal()), (String)"thermalexpansion:dynamo/Dynamo_Magmatic", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)("Dynamo" + Types.COMPRESSION.ordinal()), (String)"thermalexpansion:dynamo/Dynamo_Compression", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)("Dynamo" + Types.REACTANT.ordinal()), (String)"thermalexpansion:dynamo/Dynamo_Reactant", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)("Dynamo" + Types.ENERVATION.ordinal()), (String)"thermalexpansion:dynamo/Dynamo_Enervation", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileDynamoBase tileDynamoBase = (TileDynamoBase)world.func_147438_o(n, n2, n3);
        if (tileDynamoBase != null) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            nBTTagCompound.func_74768_a("Energy", tileDynamoBase.getEnergyStored(ForgeDirection.UNKNOWN));
            tileDynamoBase.writeAugmentsToNBT(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public boolean initialize() {
        TileDynamoBase.configure();
        TileDynamoSteam.initialize();
        TileDynamoMagmatic.initialize();
        TileDynamoCompression.initialize();
        TileDynamoReactant.initialize();
        TileDynamoEnervation.initialize();
        if (defaultRedstoneControl) {
            BlockDynamo.defaultAugments[0] = ItemHelper.cloneStack((ItemStack)TEAugments.generalRedstoneControl);
        }
        dynamoSteam = ItemBlockDynamo.setDefaultTag(new ItemStack((Block)this, 1, Types.STEAM.ordinal()));
        dynamoMagmatic = ItemBlockDynamo.setDefaultTag(new ItemStack((Block)this, 1, Types.MAGMATIC.ordinal()));
        dynamoCompression = ItemBlockDynamo.setDefaultTag(new ItemStack((Block)this, 1, Types.COMPRESSION.ordinal()));
        dynamoReactant = ItemBlockDynamo.setDefaultTag(new ItemStack((Block)this, 1, Types.REACTANT.ordinal()));
        dynamoEnervation = ItemBlockDynamo.setDefaultTag(new ItemStack((Block)this, 1, Types.ENERVATION.ordinal()));
        GameRegistry.registerCustomItemStack((String)"dynamoSteam", (ItemStack)dynamoSteam);
        GameRegistry.registerCustomItemStack((String)"dynamoMagmatic", (ItemStack)dynamoMagmatic);
        GameRegistry.registerCustomItemStack((String)"dynamoCompression", (ItemStack)dynamoCompression);
        GameRegistry.registerCustomItemStack((String)"dynamoReactant", (ItemStack)dynamoReactant);
        GameRegistry.registerCustomItemStack((String)"dynamoEnervation", (ItemStack)dynamoEnervation);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.STEAM.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(dynamoSteam, defaultAugments, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearCopper", Character.valueOf('I'), "ingotCopper", Character.valueOf('R'), "dustRedstone"}));
        }
        if (enable[Types.MAGMATIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(dynamoMagmatic, defaultAugments, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearInvar", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "dustRedstone"}));
        }
        if (enable[Types.COMPRESSION.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(dynamoCompression, defaultAugments, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearTin", Character.valueOf('I'), "ingotTin", Character.valueOf('R'), "dustRedstone"}));
        }
        if (enable[Types.REACTANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(dynamoReactant, defaultAugments, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearBronze", Character.valueOf('I'), "ingotBronze", Character.valueOf('R'), "dustRedstone"}));
        }
        if (enable[Types.ENERVATION.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(dynamoEnervation, defaultAugments, new Object[]{" C ", "GIG", "IRI", Character.valueOf('C'), TEItems.powerCoilSilver, Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "dustRedstone"}));
        }
        TECraftingHandler.addSecureRecipe(dynamoSteam);
        TECraftingHandler.addSecureRecipe(dynamoMagmatic);
        TECraftingHandler.addSecureRecipe(dynamoCompression);
        TECraftingHandler.addSecureRecipe(dynamoEnervation);
        TECraftingHandler.addSecureRecipe(dynamoReactant);
        return true;
    }

    public static void refreshItemStacks() {
        dynamoSteam = ItemBlockDynamo.setDefaultTag(dynamoSteam);
        dynamoMagmatic = ItemBlockDynamo.setDefaultTag(dynamoMagmatic);
        dynamoCompression = ItemBlockDynamo.setDefaultTag(dynamoCompression);
        dynamoReactant = ItemBlockDynamo.setDefaultTag(dynamoReactant);
        dynamoEnervation = ItemBlockDynamo.setDefaultTag(dynamoEnervation);
    }

    static {
        int n;
        boundingBox = new AxisAlignedBB[12];
        Object object = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
        Vector3 vector3 = new Vector3(0.5, 0.5, 0.5);
        BlockDynamo.boundingBox[1] = object.toAABB();
        BlockDynamo.boundingBox[0] = object.apply(Rotation.sideRotations[1].at(vector3)).toAABB();
        for (n = 2; n < 6; ++n) {
            BlockDynamo.boundingBox[n] = object.copy().apply(Rotation.sideRotations[n].at(vector3)).toAABB();
        }
        object = new Cuboid6(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
        BlockDynamo.boundingBox[7] = object.toAABB();
        BlockDynamo.boundingBox[6] = object.apply(Rotation.sideRotations[1].at(vector3)).toAABB();
        for (n = 2; n < 6; ++n) {
            BlockDynamo.boundingBox[n + 6] = object.copy().apply(Rotation.sideRotations[n].at(vector3)).toAABB();
        }
        NAMES = new String[]{"steam", "magmatic", "compression", "reactant", "enervation"};
        enable = new boolean[Types.values().length];
        defaultAugments = new ItemStack[4];
        defaultRedstoneControl = true;
        object = "Dynamo.";
        for (int i = 0; i < Types.values().length; ++i) {
            BlockDynamo.enable[i] = ThermalExpansion.config.get((String)object + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        STEAM,
        MAGMATIC,
        COMPRESSION,
        REACTANT,
        ENERVATION;

    }
}

