/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.renderers;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.ModelHead;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockSkull;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelperClient;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityBlockSkullRenderer
extends TileEntitySpecialRenderer {
    private ModelHead model;
    private final RenderBlocks renderer = new RenderBlocks();
    public static TileEntityBlockSkullRenderer instance;
    private static EntityLiving entity;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileEntityBlockSkull tileSkull = (TileEntityBlockSkull)tile;
        this.renderHead((float)x, (float)y, (float)z, tileSkull.func_145832_p() & 7, (float)(tileSkull.func_145906_b() * 360) / 16.0f, tileSkull.func_145904_a(), tileSkull.func_152108_a());
    }

    public void func_147497_a(TileEntityRendererDispatcher renderer) {
        super.func_147497_a(renderer);
        instance = this;
    }

    private EntityLiving getEntity() {
        if (entity == null) {
            entity = new EntityLiving((World)Minecraft.func_71410_x().field_71441_e){};
        }
        return entity;
    }

    public void renderHead(float x, float y, float z, int meta, float skullRotation, int skullType, GameProfile playerName) {
        if (skullType < 0 || skullType >= SkullTypes.values().length) {
            return;
        }
        SkullTypes type = SkullTypes.values()[skullType];
        if (type == SkullTypes.lycanites) {
            this.renderLycanites(x, y, z, meta, skullRotation, type, playerName);
        } else {
            this.renderNormal(x, y, z, meta, skullRotation, type, playerName);
        }
    }

    private void renderLycanites(float x, float y, float z, int meta, float skullRotation, SkullTypes type, GameProfile playerName) {
        if (playerName == null || !HeadUtils.lycanites) {
            return;
        }
        ModelBase model = LycanitesHelperClient.getModel(playerName.getName());
        ResourceLocation tex = type.getTexture(playerName);
        if (model != null && tex != null) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3008);
            this.translateHead(x, y + 1.75f, z, meta);
            skullRotation = this.adjustRotation(meta, skullRotation);
            GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
            GL11.glRotated((double)skullRotation, (double)0.0, (double)1.0, (double)0.0);
            this.func_147499_a(tex);
            model.func_78088_a((Entity)this.getEntity(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
            GL11.glPopMatrix();
        }
    }

    private void renderNormal(float x, float y, float z, int meta, float skullRotation, SkullTypes type, GameProfile playerName) {
        this.func_147499_a(type.getTexture(playerName));
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3008);
        this.translateHead(x, y, z, meta);
        skullRotation = this.adjustRotation(meta, skullRotation);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.model = ModelHead.getHead(type);
        this.model.render(skullRotation);
        this.renderSpecial(type, skullRotation);
        if (GL11.glIsEnabled((int)3042)) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    private void renderSpecial(SkullTypes skullType, float skullRotation) {
        ResourceLocation secondTex = skullType.getSecondTexture();
        if (secondTex != null) {
            this.func_147499_a(secondTex);
            switch (skullType) {
                case sheep: 
                case bighorn: 
                case taintedSheep: {
                    int c = 12;
                    if (skullType == SkullTypes.bighorn) {
                        GL11.glColor3f((float)EntitySheep.field_70898_d[c][0], (float)EntitySheep.field_70898_d[c][1], (float)EntitySheep.field_70898_d[c][2]);
                    }
                    this.model.renderOverlay(skullRotation);
                    return;
                }
                case mooshroom: {
                    GL11.glScaled((double)1.0, (double)-1.0, (double)1.0);
                    GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                    GL11.glEnable((int)2884);
                    this.renderer.func_147800_a((Block)Blocks.field_150337_Q, 0, 1.0f);
                    GL11.glDisable((int)2884);
                    return;
                }
                case spider: 
                case caveSpider: 
                case hedgeSpider: 
                case kingSpider: 
                case enderDragon: 
                case enderman: 
                case swarmSpider: 
                case towerBroodling: 
                case heatscarSpider: 
                case enderminy: {
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)3008);
                    GL11.glBlendFunc((int)1, (int)1);
                    GL11.glDepthMask((boolean)true);
                    int c0 = 61680;
                    int j = c0 % 65536;
                    int k = c0 / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
                    this.model.render(skullRotation);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                    return;
                }
            }
            return;
        }
    }

    private void translateHead(float x, float y, float z, int meta) {
        switch (meta) {
            case 1: {
                GL11.glTranslatef((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
                break;
            }
            case 2: {
                GL11.glTranslatef((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.74f));
                break;
            }
            case 3: {
                GL11.glTranslatef((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.26f));
                break;
            }
            case 4: {
                GL11.glTranslatef((float)(x + 0.74f), (float)(y + 0.25f), (float)(z + 0.5f));
                break;
            }
            default: {
                GL11.glTranslatef((float)(x + 0.26f), (float)(y + 0.25f), (float)(z + 0.5f));
            }
        }
    }

    protected float adjustRotation(int meta, float rotation) {
        switch (meta) {
            case 1: 
            case 2: {
                return rotation;
            }
            case 3: {
                return 180.0f;
            }
            case 4: {
                return 270.0f;
            }
        }
        return 90.0f;
    }
}

