/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.network.packet;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.common.network.ByteBufUtils;
import ganymedes01.headcrumbs.network.PacketHandler;
import ganymedes01.headcrumbs.network.packet.CustomPacket;
import ganymedes01.headcrumbs.network.packet.TextureSendPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class TextureRequestPacket
extends CustomPacket {
    private String name;

    public TextureRequestPacket() {
        super(PacketHandler.PacketType.TEXTURE_REQUEST);
    }

    public TextureRequestPacket(String name) {
        this();
        this.name = name;
    }

    @Override
    public void writeData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
    }

    @Override
    public void readData(ByteBuf buffer) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(World world, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(World world, final EntityPlayer player) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(TextureRequestPacket.this.name);
                if (profile != null) {
                    Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
                    if (property == null) {
                        profile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(profile, true);
                    }
                    PacketHandler.sendToPlayer(new TextureSendPacket(profile), player);
                }
            }
        }, this.name).start();
    }
}

