/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.eventHandlers;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.TileEntityBlockSkullRenderer;
import ganymedes01.headcrumbs.utils.TextureUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPlayerHandler {
    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (event.entityPlayer != null) {
            ModelBiped model = event.renderer.field_77109_a;
            if (model == null) {
                return;
            }
            ItemStack head = event.entityPlayer.field_71071_by.func_70440_f(3);
            if (head != null && head.func_77973_b() == ModItems.skull) {
                this.setHiddenState(model, true);
            } else if (head == null || !this.isGanysEndHead(head.func_77973_b())) {
                this.setHiddenState(model, false);
            }
        }
    }

    private boolean isGanysEndHead(Item item) {
        return Headcrumbs.ganysEndSkull != null && Headcrumbs.ganysEndSkull == item;
    }

    @SubscribeEvent
    public void renderHelmetEvent(RenderPlayerEvent.Specials.Post event) {
        if (event.entityPlayer != null) {
            ModelBiped model = event.renderer.field_77109_a;
            ItemStack head = event.entityPlayer.field_71071_by.func_70440_f(3);
            if (head != null && head.func_77973_b() == ModItems.skull) {
                float offset;
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.setHiddenState(model, false);
                model.field_78116_c.func_78794_c(0.0625f);
                this.setHiddenState(model, true);
                GL11.glPushMatrix();
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                switch (SkullTypes.values()[head.func_77960_j()]) {
                    case cow: 
                    case mooshroom: 
                    case slimeBeetle: 
                    case fireBeetle: 
                    case pinchBeetle: 
                    case towerGolem: 
                    case taintedCow: 
                    case pech: {
                        offset = 1.0f;
                        break;
                    }
                    case wolf: 
                    case chicken: 
                    case wildDeer: 
                    case ocelot: 
                    case ocelotBlack: 
                    case ocelotRed: 
                    case ocelotSiamese: 
                    case silverfish: 
                    case mistWolf: 
                    case winterWolf: 
                    case towerwoodBorer: 
                    case taintedChicken: {
                        offset = 2.0f;
                        break;
                    }
                    case bunnyDutch: 
                    case bunnyBrown: 
                    case bunnyWhite: 
                    case bat: 
                    case squirrel: 
                    case fireBat: {
                        offset = 3.0f;
                        break;
                    }
                    default: {
                        offset = 0.0f;
                    }
                }
                GameProfile profile = null;
                if (head.func_77942_o()) {
                    if (head.func_77978_p().func_150297_b("SkullOwner", 10)) {
                        profile = NBTUtil.func_152459_a((NBTTagCompound)head.func_77978_p().func_74775_l("SkullOwner"));
                    } else if (head.func_77978_p().func_150297_b("SkullOwner", 8)) {
                        String username = head.func_77978_p().func_74779_i("SkullOwner");
                        profile = TextureUtils.profiles.containsKey(username) ? TextureUtils.profiles.get(username) : new GameProfile(null, username);
                    }
                }
                TileEntityBlockSkullRenderer.instance.renderHead(-0.5f, 0.0f, -0.5f + offset * 0.0625f, 1, 180.0f, head.func_77960_j(), profile);
                GL11.glPopMatrix();
            }
        }
    }

    private void setHiddenState(ModelBiped model, boolean isHidden) {
        model.field_78116_c.field_78807_k = isHidden;
        model.field_78114_d.field_78807_k = isHidden;
    }
}

