/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.armor.core.handler;

import com.google.common.io.Files;
import dmillerw.armor.core.inventory.InventoryArmor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerHandler {
    private static HashMap<String, InventoryArmor> playerArmor = new HashMap();

    public static void clearArmor(EntityPlayer player) {
        playerArmor.remove(player.func_70005_c_());
    }

    public static InventoryArmor getArmor(EntityPlayer player) {
        if (!playerArmor.containsKey(player.func_70005_c_())) {
            InventoryArmor inventory = new InventoryArmor(player);
            playerArmor.put(player.func_70005_c_(), inventory);
        }
        return playerArmor.get(player.func_70005_c_());
    }

    public static void setArmor(EntityPlayer player, InventoryArmor inventory) {
        playerArmor.put(player.func_70005_c_(), inventory);
    }

    public static void loadPlayerArmor(EntityPlayer player, File file1, File file2) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            try {
                FileInputStream fileinputstream;
                NBTTagCompound data = null;
                boolean save = false;
                if (file1 != null && file1.exists()) {
                    try {
                        fileinputstream = new FileInputStream(file1);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((file1 == null || !file1.exists() || data == null || data.func_82582_d()) && file2 != null && file2.exists()) {
                    try {
                        fileinputstream = new FileInputStream(file2);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                        save = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (data != null) {
                    InventoryArmor inventory = new InventoryArmor(player);
                    inventory.readFromNBT(data);
                    playerArmor.put(player.func_70005_c_(), inventory);
                    if (save) {
                        PlayerHandler.savePlayerArmor(player, file1, file2);
                    }
                }
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
    }

    public static void savePlayerArmor(EntityPlayer player, File file1, File file2) {
        block11: {
            if (player != null && !player.field_70170_p.field_72995_K) {
                try {
                    if (file1 != null && file1.exists()) {
                        try {
                            Files.copy((File)file1, (File)file2);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    try {
                        if (file1 != null) {
                            InventoryArmor inventory = PlayerHandler.getArmor(player);
                            NBTTagCompound data = new NBTTagCompound();
                            inventory.writeToNBT(data);
                            FileOutputStream fileoutputstream = new FileOutputStream(file1);
                            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                            fileoutputstream.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (!file1.exists()) break block11;
                        try {
                            file1.delete();
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Exception exception1) {
                    exception1.printStackTrace();
                }
            }
        }
    }
}

