/*
 * Decompiled with CFR 0.152.
 */
package openblocks.shapes;

import net.minecraft.util.StatCollector;
import openmods.shapes.IShapeGenerator;
import openmods.shapes.ShapeCuboidGenerator;
import openmods.shapes.ShapeCylinderGenerator;
import openmods.shapes.ShapeDomeGenerator;
import openmods.shapes.ShapeEquilateral2dGenerator;
import openmods.shapes.ShapeSphereGenerator;

public enum GuideShape {
    Sphere(false, (IShapeGenerator)new ShapeSphereGenerator(), "sphere"),
    Cylinder(false, (IShapeGenerator)new ShapeCylinderGenerator(), "cylinder"),
    Cuboid(false, (IShapeGenerator)new ShapeCuboidGenerator(), "cuboid"),
    Dome(false, (IShapeGenerator)new ShapeDomeGenerator(), "dome"),
    Triangle(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(3), "triangle"),
    Pentagon(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(5), "pentagon"),
    Hexagon(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(6), "hexagon"),
    Octagon(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(8), "octagon");

    public final String unlocalizedName;
    public final boolean fixedRatio;
    public final IShapeGenerator generator;
    public static final GuideShape[] VALUES;

    private GuideShape(boolean fixedRatio, IShapeGenerator generator, String name) {
        this.unlocalizedName = "openblocks.misc.shape." + name;
        this.fixedRatio = fixedRatio;
        this.generator = generator;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    static {
        VALUES = GuideShape.values();
    }
}

