/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiBigButton;
import openblocks.common.container.ContainerBigButton;
import openmods.api.IActivateAwareTile;
import openmods.api.IHasGui;
import openmods.api.ISurfaceAttachment;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityBigButton
extends SyncedTileEntity
implements IActivateAwareTile,
ISurfaceAttachment,
IHasGui,
IInventoryProvider,
ISyncListener {
    private int tickCounter = 0;
    private SyncableFlags flags;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "bigbutton", true, 1));

    public TileEntityBigButton() {
        this.syncMap.addUpdateListener(this.createRenderUpdateListener());
        this.syncMap.addSyncListener((ISyncListener)this);
    }

    protected void createSyncedFields() {
        this.flags = SyncableFlags.create((int)Flags.values().length);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.tickCounter > 0) {
            --this.tickCounter;
            if (this.tickCounter <= 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.click", 0.3f, 0.5f);
                this.flags.off((Enum)Flags.active);
                this.sync();
            }
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerBigButton((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiBigButton(new ContainerBigButton((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return false;
    }

    public int getTickTime() {
        ItemStack stack = this.inventory.func_70301_a(0);
        return stack == null ? 1 : stack.field_77994_a;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            if (player.func_70093_af()) {
                this.openGui(OpenBlocks.instance, player);
            } else {
                this.flags.on((Enum)Flags.active);
                this.tickCounter = this.getTickTime();
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.click", 0.3f, 0.6f);
                this.sync();
            }
        }
        return true;
    }

    public ForgeDirection getSurfaceDirection() {
        return this.getRotation();
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
    }

    public boolean isButtonActive() {
        return this.flags.get((Enum)Flags.active);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void onSync(Set<ISyncableObject> changes) {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)OpenBlocks.Blocks.bigButton);
        ForgeDirection rot = this.getRotation();
        this.field_145850_b.func_147459_d(this.field_145851_c + rot.offsetX, this.field_145848_d + rot.offsetY, this.field_145849_e + rot.offsetZ, (Block)OpenBlocks.Blocks.bigButton);
    }

    public static enum Flags {
        active;

    }
}

