/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0APacketUseBed;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import openblocks.OpenBlocks;
import openblocks.asm.EntityPlayerVisitor;
import openblocks.client.model.ModelSleepingBag;
import openmods.infobook.BookDocumentation;
import openmods.reflection.FieldAccess;
import openmods.utils.BlockUtils;
import openmods.utils.ItemUtils;
import openmods.utils.TagUtils;

@BookDocumentation(customName="sleepingbag")
public class ItemSleepingBag
extends ItemArmor {
    private static final String TAG_SPAWN = "Spawn";
    private static final String TAG_POSITION = "Position";
    private static final String TAG_SLEEPING = "Sleeping";
    private static final String TAG_SLOT = "Slot";
    private static final int ARMOR_CHESTPIECE_TYPE = 1;
    private static final int ARMOR_CHESTPIECE_SLOT = 2;
    private static final FieldAccess<Boolean> IS_SLEEPING = FieldAccess.create(EntityPlayer.class, (String[])new String[]{"sleeping", "field_71083_bS"});
    private static final FieldAccess<Integer> SLEEPING_TIMER = FieldAccess.create(EntityPlayer.class, (String[])new String[]{"sleepTimer", "field_71076_b"});
    public static final String TEXTURE_SLEEPINGBAG = "openblocks:textures/models/sleepingbag.png";

    public ItemSleepingBag() {
        super(ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE_SLEEPINGBAG;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a("openblocks:sleepingbag");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return armorSlot == 1 ? ModelSleepingBag.instance : null;
    }

    public ItemStack func_77659_a(ItemStack sleepingBagStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack currentArmor = ItemSleepingBag.getChestpieceSlot(player);
            if (currentArmor != null) {
                currentArmor = currentArmor.func_77946_l();
            }
            ItemStack sleepingBagCopy = sleepingBagStack.func_77946_l();
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)sleepingBagCopy);
            tag.func_74768_a(TAG_SLOT, player.field_71071_by.field_70461_c);
            ItemSleepingBag.setChestpieceSlot(player, sleepingBagCopy);
            if (currentArmor != null) {
                return currentArmor;
            }
            sleepingBagStack.field_77994_a = 0;
        }
        return sleepingBagStack;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 1;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (player.func_70608_bn()) {
            return;
        }
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)itemStack);
        if (!EntityPlayerVisitor.IsInBedHookSuccess) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("openblocks.misc.sleeping_bag_broken", new Object[0]));
            ItemSleepingBag.getOutOfSleepingBag(player);
        } else if (tag.func_74767_n(TAG_SLEEPING)) {
            ItemSleepingBag.restoreOriginalSpawn(player, tag);
            ItemSleepingBag.restoreOriginalPosition((Entity)player, tag);
            tag.func_82580_o(TAG_SLEEPING);
            ItemSleepingBag.getOutOfSleepingBag(player);
        } else {
            int posZ;
            int posY;
            int posX = MathHelper.func_76128_c((double)player.field_70165_t);
            if (ItemSleepingBag.canPlayerSleep(player, world, posX, posY = MathHelper.func_76128_c((double)player.field_70163_u), posZ = MathHelper.func_76128_c((double)player.field_70161_v))) {
                ItemSleepingBag.storeOriginalSpawn(player, tag);
                ItemSleepingBag.storeOriginalPosition((Entity)player, tag);
                tag.func_74757_a(TAG_SLEEPING, true);
                ItemSleepingBag.sleepSafe((EntityPlayerMP)player, world, posX, posY, posZ);
            } else {
                ItemSleepingBag.getOutOfSleepingBag(player);
            }
        }
    }

    private static EntityPlayer.EnumStatus sleepSafe(EntityPlayerMP player, World world, int x, int y, int z) {
        if (player.func_70115_ae()) {
            player.func_70078_a(null);
        }
        IS_SLEEPING.set((Object)player, (Object)true);
        SLEEPING_TIMER.set((Object)player, (Object)0);
        player.field_71081_bT = new ChunkCoordinates(x, y, z);
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        player.field_70159_w = 0.0;
        world.func_72854_c();
        S0APacketUseBed sleepPacket = new S0APacketUseBed((EntityPlayer)player, x, y, z);
        player.func_71121_q().func_73039_n().func_151247_a((Entity)player, (Packet)sleepPacket);
        player.field_71135_a.func_147359_a((Packet)sleepPacket);
        return EntityPlayer.EnumStatus.OK;
    }

    private static EntityPlayer.EnumStatus vanillaCanSleep(EntityPlayer player, World world, int x, int y, int z) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, x, y, z);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.result != null) {
            return event.result;
        }
        if (player.func_70608_bn() || !player.func_70089_S()) {
            return EntityPlayer.EnumStatus.OTHER_PROBLEM;
        }
        if (!world.field_73011_w.func_76569_d()) {
            return EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE;
        }
        if (world.func_72935_r()) {
            return EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW;
        }
        List list = world.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)(x - 8), (double)(y - 5), (double)(z - 8), (double)(x + 8), (double)(y + 5), (double)(z + 8)));
        if (!list.isEmpty()) {
            return EntityPlayer.EnumStatus.NOT_SAFE;
        }
        return EntityPlayer.EnumStatus.OK;
    }

    private static boolean canPlayerSleep(EntityPlayer player, World world, int x, int y, int z) {
        if (!ItemSleepingBag.isNotSuffocating(world, x, y, z) || !ItemSleepingBag.isSolidEnough(world, x, y - 1, z)) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("openblocks.misc.oh_no_ground", new Object[0]));
            return false;
        }
        EntityPlayer.EnumStatus status = ItemSleepingBag.vanillaCanSleep(player, world, x, y, z);
        if (status == EntityPlayer.EnumStatus.OK) {
            return true;
        }
        switch (status) {
            case NOT_POSSIBLE_NOW: {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
                break;
            }
            case NOT_SAFE: {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
                break;
            }
        }
        return false;
    }

    private static boolean isNotSuffocating(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149668_a(world, x, y, z) == null || world.func_147437_c(x, y, z);
    }

    private static boolean isSolidEnough(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        AxisAlignedBB aabb = block.func_149668_a(world, x, y, z);
        if (aabb == null) {
            return false;
        }
        double dx = aabb.field_72336_d - aabb.field_72340_a;
        double dy = aabb.field_72337_e - aabb.field_72338_b;
        double dz = aabb.field_72334_f - aabb.field_72339_c;
        return dx >= 0.5 && dy >= 0.5 && dz >= 0.5;
    }

    private static boolean isChestplate(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemSleepingBag) {
            return false;
        }
        if (item instanceof ItemArmor) {
            ItemArmor armorItem = (ItemArmor)item;
            return armorItem.field_77881_a == 1;
        }
        return false;
    }

    private static Integer getReturnSlot(NBTTagCompound tag) {
        int slot;
        if (tag.func_150297_b(TAG_SLOT, 99) && (slot = tag.func_74762_e(TAG_SLOT)) < 9 && slot >= 0) {
            return slot;
        }
        return null;
    }

    private static boolean tryReturnToSlot(EntityPlayer player, ItemStack sleepingBag) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)sleepingBag);
        Integer returnSlot = ItemSleepingBag.getReturnSlot(tag);
        tag.func_82580_o(TAG_SLOT);
        if (returnSlot == null) {
            ItemSleepingBag.setChestpieceSlot(player, null);
            return false;
        }
        ItemStack possiblyArmor = player.field_71071_by.field_70462_a[returnSlot];
        if (ItemSleepingBag.isChestplate(possiblyArmor)) {
            ItemSleepingBag.setChestpieceSlot(player, possiblyArmor);
        } else {
            ItemSleepingBag.setChestpieceSlot(player, null);
            if (possiblyArmor != null) {
                return false;
            }
        }
        player.field_71071_by.func_70299_a(returnSlot.intValue(), sleepingBag);
        return true;
    }

    private static void getOutOfSleepingBag(EntityPlayer player) {
        ItemStack stack = ItemSleepingBag.getChestpieceSlot(player);
        if (ItemSleepingBag.isSleepingBag(stack) && !ItemSleepingBag.tryReturnToSlot(player, stack) && !player.field_71071_by.func_70441_a(stack)) {
            BlockUtils.dropItemStackInWorld((World)player.field_70170_p, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack);
        }
    }

    private static void storeOriginalSpawn(EntityPlayer player, NBTTagCompound tag) {
        ChunkCoordinates spawn = player.getBedLocation(player.field_70170_p.field_73011_w.field_76574_g);
        if (spawn != null) {
            tag.func_74782_a(TAG_SPAWN, (NBTBase)TagUtils.store((ChunkCoordinates)spawn));
        }
    }

    private static void restoreOriginalSpawn(EntityPlayer player, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_SPAWN)) {
            ChunkCoordinates coords = TagUtils.readCoord((NBTTagCompound)tag.func_74775_l(TAG_SPAWN)).asChunkCoordinate();
            player.setSpawnChunk(coords, false, player.field_70170_p.field_73011_w.field_76574_g);
            tag.func_82580_o(TAG_SPAWN);
        }
    }

    private static void storeOriginalPosition(Entity e, NBTTagCompound tag) {
        tag.func_74782_a(TAG_POSITION, (NBTBase)TagUtils.store((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v));
    }

    private static void restoreOriginalPosition(Entity e, NBTTagCompound tag) {
        if (tag.func_74764_b(TAG_POSITION)) {
            Vec3 position = TagUtils.readVec((NBTTagCompound)tag.func_74775_l(TAG_POSITION));
            e.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
            tag.func_82580_o(TAG_POSITION);
        }
    }

    public static boolean isWearingSleepingBag(EntityPlayer player) {
        ItemStack armor = ItemSleepingBag.getChestpieceSlot(player);
        return ItemSleepingBag.isSleepingBag(armor);
    }

    private static boolean isSleepingBag(ItemStack armor) {
        return armor != null && armor.func_77973_b() instanceof ItemSleepingBag;
    }

    private static ItemStack setChestpieceSlot(EntityPlayer player, ItemStack chestpiece) {
        player.field_71071_by.field_70460_b[2] = chestpiece;
        return player.field_71071_by.field_70460_b[2];
    }

    private static ItemStack getChestpieceSlot(EntityPlayer player) {
        return player.field_71071_by.field_70460_b[2];
    }
}

