/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import openblocks.Config;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;

public class ElevatorBlockRules {
    public static final ElevatorBlockRules instance = new ElevatorBlockRules();
    private static final Map<String, Action> ACTIONS;
    private Map<Block, Action> rules;

    private ElevatorBlockRules() {
    }

    private Map<Block, Action> getRules() {
        if (this.rules == null) {
            this.rules = Maps.newIdentityHashMap();
            for (String entry : Config.elevatorRules) {
                try {
                    ElevatorBlockRules.tryAddRule(this.rules, entry);
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Invalid entry in map blacklist: %s", (Object[])new Object[]{entry});
                }
            }
        }
        return this.rules;
    }

    private static void tryAddRule(Map<Block, Action> rules, String entry) {
        String[] parts = entry.split(":");
        if (parts.length == 0) {
            return;
        }
        Preconditions.checkState((parts.length == 3 ? 1 : 0) != 0, (Object)"Each entry must have exactly 3 colon-separated fields");
        String modId = parts[0];
        String blockName = parts[1];
        String actionName = parts[2].toLowerCase();
        Action action = ACTIONS.get(actionName);
        Preconditions.checkNotNull((Object)((Object)action), (String)"Unknown action: %s", (Object[])new Object[]{actionName});
        Block block = GameRegistry.findBlock((String)modId, (String)blockName);
        if (block != null) {
            rules.put(block, action);
        } else {
            Log.warn((String)"Can't find block %s", (Object[])new Object[]{entry});
        }
    }

    @SubscribeEvent
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.check("dropblock", "specialBlockRules")) {
            this.rules = null;
        }
    }

    private static boolean isPassable(Block block) {
        return Config.elevatorIgnoreHalfBlocks && !block.func_149721_r();
    }

    public Action getActionForBlock(Block block) {
        if (block == null) {
            return Action.IGNORE;
        }
        Action action = this.getRules().get(block);
        if (action != null) {
            return action;
        }
        return ElevatorBlockRules.isPassable(block) ? Action.IGNORE : Action.INCREMENT;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Action a : Action.values()) {
            builder.put((Object)a.name().toLowerCase(), (Object)a);
        }
        ACTIONS = builder.build();
    }

    public static enum Action {
        IGNORE,
        ABORT,
        INCREMENT;

    }
}

