/*
 * Decompiled with CFR 0.152.
 */
package lib.enderwizards.sandstone.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import lib.enderwizards.sandstone.util.WorldSaveFile;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public final class WorldDataHandler {
    private static WorldDataHandler instance;
    private final Map<Class<? extends WorldSaveFile>, WorldSaveFile> cache = new IdentityHashMap<Class<? extends WorldSaveFile>, WorldSaveFile>();
    private File worldSaveDir;
    private String worldIdentifier = "";

    public static void register() {
        if (instance == null) {
            instance = new WorldDataHandler();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    public static <T> T get(Class<? extends WorldSaveFile> cls) {
        WorldSaveFile savefile = WorldDataHandler.instance.cache.get(cls);
        if (savefile == null) {
            try {
                savefile = cls.newInstance();
                WorldDataHandler.instance.cache.put(cls, savefile);
                File file = new File(WorldDataHandler.instance.worldSaveDir, savefile.filename);
                if (file.exists()) {
                    try {
                        savefile.loadFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
                    }
                    catch (IOException iOException) {}
                } else {
                    savefile.loadFromNBT(new NBTTagCompound());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not construct a new instance of WorldSaveFile - " + cls.getName(), e);
            }
        }
        return (T)savefile;
    }

    public static void forceSave() {
        instance.saveModified();
    }

    private WorldDataHandler() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_72995_K) {
            return;
        }
        String id = e.world.func_72860_G().func_75760_g() + e.world.func_72912_H().func_76065_j() + e.world.func_72912_H().func_76063_b();
        if (!this.worldIdentifier.equals(id)) {
            this.cache.clear();
            this.worldIdentifier = id;
            File root = DimensionManager.getCurrentSaveRootDirectory();
            if (root != null) {
                this.worldSaveDir = new File(root, "libSandStoneData");
                if (!this.worldSaveDir.exists()) {
                    this.worldSaveDir.mkdirs();
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        this.saveModified();
    }

    private void saveModified() {
        if (this.worldSaveDir == null) {
            return;
        }
        for (WorldSaveFile savefile : this.cache.values()) {
            if (!savefile.wasModified()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            savefile.saveToNBT(nbt);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(new File(this.worldSaveDir, savefile.filename)));
            }
            catch (Exception ex) {}
        }
    }
}

