/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.helpers.RotorInfo;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurbineRotorBearing
extends TileEntityTurbinePartStandard {
    RotorInfo rotorInfo = null;
    Integer displayList = null;
    float angle = 0.0f;
    protected AxisAlignedBB boundingBox;

    @SideOnly(value=Side.CLIENT)
    public Integer getDisplayList() {
        return this.displayList;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDisplayList(int newList) {
        this.displayList = newList;
    }

    @SideOnly(value=Side.CLIENT)
    public void clearDisplayList() {
        this.displayList = null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getAngle() {
        return this.angle;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAngle(float newAngle) {
        this.angle = newAngle;
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.displayList = null;
        this.calculateRotorInfo();
    }

    @SideOnly(value=Side.CLIENT)
    public RotorInfo getRotorInfo() {
        return this.rotorInfo;
    }

    public AxisAlignedBB getAABB() {
        return this.boundingBox;
    }

    private void calculateRotorInfo() {
        MultiblockTurbine turbine = this.getTurbine();
        CoordTriplet minCoord = turbine.getMinimumCoord();
        CoordTriplet maxCoord = turbine.getMaximumCoord();
        this.boundingBox = AxisAlignedBB.func_72330_a((double)minCoord.x, (double)minCoord.y, (double)minCoord.z, (double)(maxCoord.x + 1), (double)(maxCoord.y + 1), (double)(maxCoord.z + 1));
        if (this.field_145850_b.field_72995_K) {
            this.rotorInfo = new RotorInfo();
            this.rotorInfo.rotorDirection = this.getOutwardsDir().getOpposite();
            switch (this.rotorInfo.rotorDirection) {
                case DOWN: 
                case UP: 
                case UNKNOWN: {
                    this.rotorInfo.rotorLength = maxCoord.y - minCoord.y - 1;
                    break;
                }
                case EAST: 
                case WEST: {
                    this.rotorInfo.rotorLength = maxCoord.x - minCoord.x - 1;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.rotorInfo.rotorLength = maxCoord.z - minCoord.z - 1;
                }
            }
            CoordTriplet currentCoord = this.getWorldLocation();
            CoordTriplet bladeCoord = new CoordTriplet(0, 0, 0);
            ForgeDirection[] dirsToCheck = StaticUtils.neighborsBySide[this.rotorInfo.rotorDirection.ordinal()];
            this.rotorInfo.bladeLengths = new int[this.rotorInfo.rotorLength][4];
            currentCoord.translate(this.rotorInfo.rotorDirection);
            for (int rotorPosition = 0; rotorPosition < this.rotorInfo.rotorLength; ++rotorPosition) {
                for (int bladeIdx = 0; bladeIdx < dirsToCheck.length; ++bladeIdx) {
                    int bladeLength;
                    ForgeDirection bladeDir = dirsToCheck[bladeIdx];
                    bladeCoord.copy(currentCoord);
                    bladeCoord.translate(bladeDir);
                    for (bladeLength = 0; this.field_145850_b.func_147439_a(bladeCoord.x, bladeCoord.y, bladeCoord.z) == BigReactors.blockTurbineRotorPart && bladeLength < 32; ++bladeLength) {
                        bladeCoord.translate(bladeDir);
                    }
                    this.rotorInfo.bladeLengths[rotorPosition][bladeIdx] = bladeLength;
                }
                currentCoord.translate(this.rotorInfo.rotorDirection);
            }
        }
    }
}

