/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.command.LuckyCommandLogic;
import mod.lucky.drop.LuckyDrop;
import mod.lucky.drop.LuckyDropBase;
import mod.lucky.item.ItemLuckyBlock;
import mod.lucky.tileentity.TileEntityLuckyBlock;
import mod.lucky.util.ChooseLuckyDrop;
import mod.lucky.util.LuckyFunction;
import mod.lucky.util.MakeLuckyDrops;
import mod.lucky.util.SpawnEntity;
import mod.lucky.util.SpawnOther;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockLuckyBlock
extends BlockContainer {
    public SpawnOther spawnOther;
    public SpawnEntity spawnEntity;
    public MakeLuckyDrops makeLuckyDrops;
    private final Random random = new Random();

    public BlockLuckyBlock(Material material) {
        super(material);
        this.spawnEntity = new SpawnEntity();
        this.spawnOther = new SpawnOther();
        this.makeLuckyDrops = new MakeLuckyDrops();
    }

    public void func_149695_a(World world, int posX, int posY, int posZ, Block block) {
        if (world.func_72864_z(posX, posY, posZ)) {
            this.removeLuckyBlock(world, null, posX, posY, posZ, true);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int harvestX, int harvestY, int harvestZ) {
        return this.removeLuckyBlock(world, player, harvestX, harvestY, harvestZ, false);
    }

    public boolean removeLuckyBlock(World world, EntityPlayer player, int harvestX, int harvestY, int harvestZ, boolean removedByRedstone) {
        try {
            int luck = 0;
            String[] drops = null;
            LuckyDropBase[] savedDrops = null;
            TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_147438_o(harvestX, harvestY, harvestZ);
            if (tileEntityLuck != null) {
                luck = tileEntityLuck.getLuck();
                drops = tileEntityLuck.getDrops();
                if (drops != null && drops.length != 0) {
                    savedDrops = new LuckyDropBase[drops.length];
                    for (int a = 0; a < savedDrops.length; ++a) {
                        savedDrops[a] = new LuckyDropBase(drops[a]);
                    }
                }
                world.func_147475_p(harvestX, harvestY, harvestZ);
            }
            if (!world.func_147468_f(harvestX, harvestY, harvestZ)) {
                return false;
            }
            if (!world.field_72995_K) {
                if (removedByRedstone) {
                    LuckyCommandLogic luckyCommandLogic = new LuckyCommandLogic();
                    luckyCommandLogic.setWorld(world);
                    luckyCommandLogic.setCommandCoordinates(new ChunkCoordinates(harvestX, harvestY, harvestZ));
                    player = PlayerSelector.func_82386_a((ICommandSender)luckyCommandLogic, (String)"@p");
                }
                if (player.field_71075_bZ.field_75098_d && !Lucky.instance.doDropsOnCreativeMode && !removedByRedstone) {
                    return true;
                }
                if (EnchantmentHelper.func_77502_d((EntityLivingBase)player) && !removedByRedstone) {
                    ItemStack itemStack = new ItemStack(Lucky.lucky_block);
                    NBTTagCompound nbttag = new NBTTagCompound();
                    if (luck != 0) {
                        nbttag.func_74768_a("Luck", luck);
                    }
                    if (drops != null && drops.length != 0) {
                        nbttag.func_74782_a("Drops", (NBTBase)LuckyFunction.getNBTTagListFromArray(drops));
                    }
                    if (nbttag.func_74764_b("Luck") || nbttag.func_74764_b("Drops")) {
                        itemStack.func_77982_d(nbttag);
                    }
                    float f = 0.7f;
                    double x = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double y = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double z = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)harvestX + x, (double)harvestY + y, (double)harvestZ + z, itemStack);
                    entityitem.field_145804_b = 10;
                    world.func_72838_d((Entity)entityitem);
                    return true;
                }
                LuckyDrop[] allDrops = savedDrops != null && savedDrops.length != 0 ? this.makeLuckyDrops.getDrops(ChooseLuckyDrop.chooseDrop(savedDrops, luck), world, player, harvestX, harvestY, harvestZ) : this.makeLuckyDrops.getDrops(ChooseLuckyDrop.chooseDrop(Lucky.instance.allDrops, luck), world, player, harvestX, harvestY, harvestZ);
                this.doDrop(allDrops, world, player, world.field_73012_v, harvestX, harvestY, harvestZ);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Block encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
        return true;
    }

    public void doDrop(LuckyDrop[] allDrops, World world, EntityPlayer player, Random random, int harvestX, int harvestY, int harvestZ) {
        try {
            this.spawnEntity.setRandom(random);
            int count = 0;
            while (allDrops[count] != null) {
                LuckyDrop currDrop = allDrops[count];
                if (currDrop.getType().equals("entity")) {
                    this.spawnEntity.spawnEntity(world, player, currDrop);
                } else if (currDrop.getType().equals("effect")) {
                    PotionEffect potioneffect = new PotionEffect(Integer.valueOf(currDrop.getId()).intValue(), currDrop.getEffectDuration(), currDrop.getDamage());
                    player.func_70690_d(potioneffect);
                } else if (currDrop.getType().equals("difficulty")) {
                    EnumDifficulty enumdifficulty = !currDrop.getId().equalsIgnoreCase("peaceful") && !currDrop.getId().equalsIgnoreCase("p") ? (!currDrop.getId().equalsIgnoreCase("easy") && !currDrop.getId().equalsIgnoreCase("e") ? (!currDrop.getId().equalsIgnoreCase("normal") && !currDrop.getId().equalsIgnoreCase("n") ? (!currDrop.getId().equalsIgnoreCase("hard") && !currDrop.getId().equalsIgnoreCase("h") ? EnumDifficulty.func_151523_a((int)Integer.valueOf(currDrop.getId())) : EnumDifficulty.HARD) : EnumDifficulty.NORMAL) : EnumDifficulty.EASY) : EnumDifficulty.PEACEFUL;
                    MinecraftServer.func_71276_C().func_147139_a(enumdifficulty);
                } else if (currDrop.getType().equals("time")) {
                    for (WorldServer worldServer : MinecraftServer.func_71276_C().field_71305_c) {
                        worldServer.func_72877_b(Long.valueOf(currDrop.getId()).longValue());
                    }
                } else if (currDrop.getType().equals("sound")) {
                    world.func_72956_a((Entity)player, currDrop.getId(), 3.0f, 1.0f);
                } else if (currDrop.getType().equals("command")) {
                    LuckyCommandLogic luckyCommandLogic = new LuckyCommandLogic();
                    luckyCommandLogic.setWorld(world);
                    luckyCommandLogic.setCommandCoordinates(new ChunkCoordinates(currDrop.getPosX(), currDrop.getPosY(), currDrop.getPosZ()));
                    luckyCommandLogic.setCommand(currDrop.getId());
                    luckyCommandLogic.setCommandSender(currDrop.getCommandSender());
                    luckyCommandLogic.setDoOutput(currDrop.getDisplayCommandOutput());
                    luckyCommandLogic.executeCommand();
                } else if (currDrop.getType().equals("message")) {
                    MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(currDrop.getId()));
                } else if (currDrop.getType().equals("particle") || currDrop.getType().equals("block") || currDrop.getType().equals("structure") || currDrop.getType().equals("falling_block")) {
                    this.spawnOther.spawnOther(world, player, random, currDrop);
                } else if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
                    ItemStack itemStack;
                    float f = 0.7f;
                    double x = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double y = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double z = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    try {
                        int id = Integer.valueOf(currDrop.getId());
                        itemStack = new ItemStack((Item)Item.field_150901_e.func_148754_a(id), 1, currDrop.getDamage());
                    }
                    catch (NumberFormatException e) {
                        itemStack = new ItemStack((Item)Item.field_150901_e.func_82594_a(currDrop.getId()), 1, currDrop.getDamage());
                    }
                    itemStack.func_77982_d(currDrop.getNBTTag());
                    EntityItem entityitem = new EntityItem(world, (double)currDrop.getPosX() + x, (double)currDrop.getPosY() + y, (double)currDrop.getPosZ() + z, itemStack);
                    entityitem.field_145804_b = 10;
                    world.func_72838_d((Entity)entityitem);
                }
                ++count;
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Block encountered and error while trying to perform a function. Error report below:");
            e.printStackTrace();
        }
    }

    public Item func_149650_a(int par1, Random random, int par2) {
        return null;
    }

    private boolean canStayOnBlock(Block soil) {
        return soil == Blocks.field_150349_c || soil == Blocks.field_150346_d || soil == Blocks.field_150354_m || soil == Blocks.field_150348_b || soil == Blocks.field_150351_n || soil == Blocks.field_150424_aL || soil == Blocks.field_150425_aM || soil == Blocks.field_150385_bj || soil == Blocks.field_150385_bj || soil == Blocks.field_150377_bs;
    }

    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        Block currBlock = par1World.func_147439_a(par2, par3, par4);
        Block soil = par1World.func_147439_a(par2, par3 - 1, par4);
        return (par1World.func_72883_k(par2, par3, par4) >= 8 || par1World.func_72937_j(par2, par3, par4)) && soil != null && this.canStayOnBlock(soil);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityLuckyBlock();
    }

    public void func_149689_a(World world, int posX, int posY, int posZ, EntityLivingBase player, ItemStack itemStack) {
        TileEntityLuckyBlock tileEntityLuck = (TileEntityLuckyBlock)world.func_147438_o(posX, posY, posZ);
        if (tileEntityLuck == null) {
            return;
        }
        int luck = ItemLuckyBlock.getLuck(itemStack);
        String[] drops = ItemLuckyBlock.getDrops(itemStack);
        if (luck != 0) {
            tileEntityLuck.setLuck(luck);
        }
        if (drops != null && drops != null && drops.length != 0) {
            tileEntityLuck.setDrops(drops);
        }
        tileEntityLuck.func_70296_d();
        world.func_147471_g(posX, posY, posZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("lucky:lucky_block");
    }
}

