/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.ai;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class DragonFlightNode {
    public static final int NUM_CHILDREN = 5;
    public static final double MIN_SAMPLE_DISTANCE = 3.0;
    private Random rand = new Random();
    public DragonFlightNode[] children = new DragonFlightNode[5];
    public DragonFlightNode parent;
    public int myIdx;
    public boolean hasAlternatives;
    public double pointX;
    public double pointY;
    public double pointZ;
    public double endPointX;
    public double endPointY;
    public double endPointZ;
    public double sourceDistance;
    public double targetDistance;
    public double blockDistance;
    int idxToFastestWay;
    public double fastestSubDistance;

    DragonFlightNode(Vec3 source) {
        this.parent = null;
        this.myIdx = -1;
        this.pointX = source.field_72450_a;
        this.pointY = source.field_72448_b;
        this.pointZ = source.field_72449_c;
        this.sourceDistance = 0.0;
        this.targetDistance = 0.0;
        this.blockDistance = 9999.0;
        this.endPointX = source.field_72450_a;
        this.endPointY = source.field_72448_b;
        this.endPointZ = source.field_72449_c;
        this.hasAlternatives = false;
        this.collapseAll();
    }

    DragonFlightNode(DragonFlightNode parent, int myIdx, Vec3 source) {
        this.parent = parent;
        parent.children[myIdx] = this;
        this.myIdx = myIdx;
        this.pointX = source.field_72450_a;
        this.pointY = source.field_72448_b;
        this.pointZ = source.field_72449_c;
        Vec3 parentSource = Vec3.func_72443_a((double)parent.pointX, (double)parent.pointY, (double)parent.pointZ);
        this.sourceDistance = parent.sourceDistance + parentSource.func_72438_d(source);
        this.targetDistance = 0.0;
        this.blockDistance = 999999.0;
        this.endPointX = source.field_72450_a;
        this.endPointY = source.field_72448_b;
        this.endPointZ = source.field_72449_c;
        this.hasAlternatives = false;
        this.collapseAll();
    }

    public double getHeuristicalDistance() {
        if (this.idxToFastestWay != -1) {
            return this.sourceDistance + this.fastestSubDistance;
        }
        return this.sourceDistance + this.targetDistance;
    }

    private void updateSubCandidates() {
        int countNonNull = 0;
        double fastestSumDistance = 9999999.0;
        int idxToFastestWay = -1;
        for (int i = 0; i < 5; ++i) {
            DragonFlightNode subNode = this.children[i];
            if (subNode == null) continue;
            double otherSumDistance = subNode.getHeuristicalDistance();
            if (fastestSumDistance > otherSumDistance) {
                fastestSumDistance = otherSumDistance;
                idxToFastestWay = i;
            }
            ++countNonNull;
        }
        this.fastestSubDistance = fastestSumDistance - this.sourceDistance;
        this.idxToFastestWay = idxToFastestWay;
        this.hasAlternatives = countNonNull > 1;
        if (this.parent != null) {
            this.parent.updateSubCandidates();
        }
    }

    private void recalculateSourceDistance() {
        if (this.parent != null) {
            Vec3 parentSource = Vec3.func_72443_a((double)this.parent.pointX, (double)this.parent.pointY, (double)this.parent.pointZ);
            Vec3 source = Vec3.func_72443_a((double)this.pointX, (double)this.pointY, (double)this.pointZ);
            this.sourceDistance = this.parent.sourceDistance + parentSource.func_72438_d(source);
        } else {
            this.sourceDistance = 0.0;
        }
        for (int i = 0; i < 5; ++i) {
            DragonFlightNode subNode = this.children[i];
            if (subNode == null) continue;
            subNode.recalculateSourceDistance();
        }
    }

    public void orphanizeMe() {
        if (this.parent == null) {
            return;
        }
        this.parent.children[this.myIdx] = null;
        this.parent.updateSubCandidates();
        this.parent = null;
        this.myIdx = -1;
        this.recalculateSourceDistance();
    }

    public void eliminateSubOptimalPaths() {
        for (int i = 0; i < 5; ++i) {
            DragonFlightNode subNode = this.children[i];
            if (subNode == null || i == this.idxToFastestWay) continue;
            subNode.orphanizeMe();
        }
        this.hasAlternatives = false;
    }

    public void collapseAll() {
        for (int i = 0; i < 5; ++i) {
            DragonFlightNode subNode = this.children[i];
            if (subNode == null) continue;
            subNode.parent = null;
            subNode.sourceDistance = 0.0;
            this.children[i] = null;
        }
        this.idxToFastestWay = -1;
        this.fastestSubDistance = this.targetDistance + 9999999.0;
        this.hasAlternatives = false;
        if (this.parent != null) {
            this.parent.updateSubCandidates();
        }
    }

    private double simulateTunnelMovement(EntityCreature creature, Vec3 target) {
        int j;
        double stepSize = 1.0;
        double tunnelWallDistance = 1.0;
        World worldObj = creature.field_70170_p;
        Vec3 source = Vec3.func_72443_a((double)this.pointX, (double)this.pointY, (double)this.pointZ);
        Vec3 delta = Vec3.func_72443_a((double)(target.field_72450_a - source.field_72450_a), (double)(target.field_72448_b - source.field_72448_b), (double)(target.field_72449_c - source.field_72449_c));
        double deltaLen = delta.func_72433_c();
        int largestCoord = -1;
        largestCoord = Math.abs(delta.field_72450_a) >= Math.abs(delta.field_72448_b) ? (Math.abs(delta.field_72450_a) >= Math.abs(delta.field_72449_c) ? 0 : 2) : (Math.abs(delta.field_72448_b) >= Math.abs(delta.field_72449_c) ? 1 : 2);
        double maxCoord = 0.0;
        maxCoord = largestCoord == 0 ? Math.abs(delta.field_72450_a) : (largestCoord == 1 ? Math.abs(delta.field_72448_b) : Math.abs(delta.field_72449_c));
        if (maxCoord <= 1.0E-4) {
            return 9.9999999E7;
        }
        Vec3 stepDelta = Vec3.func_72443_a((double)(delta.field_72450_a * 1.0 / maxCoord), (double)(delta.field_72448_b * 1.0 / maxCoord), (double)(delta.field_72449_c * 1.0 / maxCoord));
        double stepDeltaLen = stepDelta.func_72433_c();
        AxisAlignedBB proxyInnerBox = creature.field_70121_D.func_72329_c();
        Vec3 center = Vec3.func_72443_a((double)((proxyInnerBox.field_72340_a + proxyInnerBox.field_72336_d) / 2.0), (double)((proxyInnerBox.field_72338_b + proxyInnerBox.field_72337_e) / 2.0), (double)((proxyInnerBox.field_72339_c + proxyInnerBox.field_72334_f) / 2.0));
        proxyInnerBox.func_72317_d(this.pointX - center.field_72450_a, this.pointY - center.field_72448_b, this.pointZ - center.field_72449_c);
        AxisAlignedBB proxyBox = proxyInnerBox.func_72314_b(1.0, 1.0, 1.0);
        proxyBox.field_72337_e += 0.5;
        proxyBox.field_72338_b -= 1.5;
        boolean tunnelCollided = false;
        double stepX = stepDelta.field_72450_a;
        double stepY = stepDelta.field_72448_b;
        double stepZ = stepDelta.field_72449_c;
        List collidersInside = worldObj.func_72945_a((Entity)creature, proxyBox.func_72321_a(stepX, stepY, stepZ));
        for (j = 0; j < collidersInside.size(); ++j) {
            AxisAlignedBB other = (AxisAlignedBB)collidersInside.get(j);
            if (!other.func_72326_a(proxyBox)) continue;
            if (other.field_72340_a <= proxyBox.field_72336_d && stepX > 0.0) {
                tunnelCollided = true;
            } else if (other.field_72336_d >= proxyBox.field_72340_a && stepX < 0.0) {
                tunnelCollided = true;
            }
            if (other.field_72338_b <= proxyBox.field_72337_e && stepY > 0.0) {
                tunnelCollided = true;
            } else if (other.field_72337_e >= proxyBox.field_72338_b && stepY < 0.0) {
                tunnelCollided = true;
            }
            if (other.field_72339_c <= proxyBox.field_72334_f && stepZ > 0.0) {
                tunnelCollided = true;
            } else if (other.field_72334_f >= proxyBox.field_72339_c && stepZ < 0.0) {
                tunnelCollided = true;
            }
            if (tunnelCollided) break;
        }
        double movedLen = 0.0;
        if (!tunnelCollided) {
            int numSteps = MathHelper.func_76128_c((double)(maxCoord / 1.0 + 1.0));
            for (int i = 0; i < numSteps; ++i) {
                stepX = stepDelta.field_72450_a;
                stepY = stepDelta.field_72448_b;
                stepZ = stepDelta.field_72449_c;
                collidersInside = worldObj.func_72945_a((Entity)creature, proxyBox.func_72321_a(stepX, stepY, stepZ));
                for (j = 0; j < collidersInside.size(); ++j) {
                    stepY = ((AxisAlignedBB)collidersInside.get(j)).func_72323_b(proxyBox, stepY);
                }
                proxyBox.func_72317_d(0.0, stepY, 0.0);
                proxyInnerBox.func_72317_d(0.0, stepY, 0.0);
                for (j = 0; j < collidersInside.size(); ++j) {
                    stepX = ((AxisAlignedBB)collidersInside.get(j)).func_72316_a(proxyBox, stepX);
                }
                proxyBox.func_72317_d(stepX, 0.0, 0.0);
                proxyInnerBox.func_72317_d(stepX, 0.0, 0.0);
                for (j = 0; j < collidersInside.size(); ++j) {
                    stepZ = ((AxisAlignedBB)collidersInside.get(j)).func_72322_c(proxyBox, stepZ);
                }
                proxyBox.func_72317_d(0.0, 0.0, stepZ);
                proxyInnerBox.func_72317_d(0.0, 0.0, stepZ);
                if (stepX != stepDelta.field_72450_a || stepY != stepDelta.field_72448_b || stepZ != stepDelta.field_72449_c) {
                    movedLen += Vec3.func_72443_a((double)stepX, (double)stepY, (double)stepZ).func_72433_c();
                    stepX = stepDelta.field_72450_a - stepX;
                    stepY = stepDelta.field_72448_b - stepY;
                    stepZ = stepDelta.field_72449_c - stepZ;
                    tunnelCollided = true;
                    break;
                }
                movedLen += stepDeltaLen;
            }
        }
        if (tunnelCollided) {
            for (j = 0; j < collidersInside.size(); ++j) {
                stepY = ((AxisAlignedBB)collidersInside.get(j)).func_72323_b(proxyInnerBox, stepY);
            }
            proxyInnerBox.func_72317_d(0.0, stepY, 0.0);
            for (j = 0; j < collidersInside.size(); ++j) {
                stepX = ((AxisAlignedBB)collidersInside.get(j)).func_72316_a(proxyInnerBox, stepX);
            }
            proxyInnerBox.func_72317_d(stepX, 0.0, 0.0);
            for (j = 0; j < collidersInside.size(); ++j) {
                stepZ = ((AxisAlignedBB)collidersInside.get(j)).func_72322_c(proxyInnerBox, stepZ);
            }
            proxyInnerBox.func_72317_d(0.0, 0.0, stepZ);
            movedLen += Vec3.func_72443_a((double)stepX, (double)stepY, (double)stepZ).func_72433_c();
        }
        if (movedLen + 0.5 > deltaLen) {
            return 9.99999999E8;
        }
        return movedLen;
    }

    private void traceTarget(EntityCreature creature, Vec3 target) {
        Vec3 source = Vec3.func_72443_a((double)this.pointX, (double)this.pointY, (double)this.pointZ);
        this.targetDistance = source.func_72438_d(target);
        this.blockDistance = this.simulateTunnelMovement(creature, target);
        this.collapseAll();
    }

    public void explore(EntityCreature creature, Vec3 target, int countNodes) {
        this.traceTarget(creature, target);
        double switchCoeff = 86.79;
        if (countNodes > 1) {
            switchCoeff /= (double)(countNodes - 1);
        }
        this.collapseAll();
        for (int i = 0; i < countNodes; ++i) {
            DragonFlightNode nextNode;
            DragonFlightNode bestNode = this;
            while ((nextNode = bestNode.pickBest()) != null) {
                bestNode = nextNode;
            }
            Vec3 delta = Vec3.func_72443_a((double)(target.field_72450_a - bestNode.pointX), (double)(target.field_72448_b - bestNode.pointY), (double)(target.field_72449_c - bestNode.pointZ));
            double deltaLength = delta.func_72433_c();
            if (!bestNode.isDirectWay()) {
                for (int j = 0; j < 5; ++j) {
                    Vec3 subTarget;
                    double subBlockDistance;
                    Vec3 direction;
                    boolean isInvalid = false;
                    block3: do {
                        isInvalid = false;
                        direction = Vec3.func_72443_a((double)(2.0 * this.rand.nextDouble() - 1.0), (double)(2.0 * this.rand.nextDouble() - 1.0), (double)(2.0 * this.rand.nextDouble() - 1.0));
                        DragonFlightNode ancNode = bestNode.parent;
                        while (ancNode != this.parent && ancNode != null) {
                            double switchProb = Math.exp(-((double)i) * switchCoeff);
                            if (this.rand.nextDouble() >= switchProb) continue block3;
                            double ancDirX = bestNode.pointX - ancNode.pointX;
                            double ancDirY = bestNode.pointY - ancNode.pointY;
                            double ancDirZ = bestNode.pointZ - ancNode.pointZ;
                            if (direction.field_72450_a * ancDirX + direction.field_72448_b * ancDirY + direction.field_72449_c * ancDirZ < 0.0) {
                                isInvalid = true;
                                continue block3;
                            }
                            ancNode = ancNode.parent;
                        }
                    } while (isInvalid);
                    direction = direction.func_72432_b();
                    double subTargetDistance = deltaLength;
                    if (subTargetDistance > 50.0) {
                        subTargetDistance = 50.0;
                    }
                    if ((subBlockDistance = bestNode.simulateTunnelMovement(creature, subTarget = Vec3.func_72443_a((double)(bestNode.pointX + direction.field_72450_a * (subTargetDistance *= 0.5 + this.rand.nextDouble() * 0.5)), (double)(bestNode.pointY + direction.field_72448_b * subTargetDistance), (double)(bestNode.pointZ + direction.field_72449_c * subTargetDistance)))) < subTargetDistance) {
                        if ((subBlockDistance *= 0.0) < 3.0) continue;
                        subTarget = Vec3.func_72443_a((double)(bestNode.pointX + direction.field_72450_a * subBlockDistance), (double)(bestNode.pointY + direction.field_72448_b * subBlockDistance), (double)(bestNode.pointZ + direction.field_72449_c * subBlockDistance));
                    }
                    DragonFlightNode subNode = new DragonFlightNode(bestNode, j, subTarget);
                    subNode.traceTarget(creature, target);
                }
                continue;
            }
            bestNode = new DragonFlightNode(bestNode, 0, target);
            return;
        }
    }

    public boolean isFinal() {
        return this.targetDistance <= 3.0;
    }

    public boolean isDirectWay() {
        return this.blockDistance + 3.0 > this.targetDistance;
    }

    public DragonFlightNode pickBest() {
        return this.idxToFastestWay != -1 ? this.children[this.idxToFastestWay] : null;
    }
}

