/*
 * Decompiled with CFR 0.152.
 */
package vazkii.emotes.client.emote.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import vazkii.emotes.client.emote.base.EmoteBase;

public final class EmoteHandler {
    public static Map<String, Class<? extends EmoteBase>> emoteMap = new TreeMap<String, Class<? extends EmoteBase>>();
    private static WeakHashMap<EntityPlayer, EmoteBase> playerEmotes = new WeakHashMap();
    private static List<EntityPlayer> updatedPlayers = new ArrayList<EntityPlayer>();

    public static void putEmote(EntityPlayer player, String emoteName) {
        if (emoteMap.containsKey(emoteName)) {
            EmoteHandler.putEmote(player, emoteMap.get(emoteName));
        } else {
            player.func_146105_b(new ChatComponentText("That emote doesn't exist. Try /emote list.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        }
    }

    public static void putEmote(EntityPlayer player, Class<? extends EmoteBase> clazz) {
        ModelBiped model = EmoteHandler.getPlayerModel();
        ModelBiped armorModel = EmoteHandler.getPlayerArmorModel();
        ModelBiped armorLegModel = EmoteHandler.getPlayerArmorLegModel();
        System.out.println(model.field_78116_c.field_78796_g);
        if (model.field_78116_c.field_78796_g < 0.0f) {
            model.field_78116_c.field_78796_g = (float)Math.PI * 2 - model.field_78116_c.field_78796_g;
        }
        try {
            if (playerEmotes.containsKey(player)) {
                player.func_146105_b(new ChatComponentText("You're already doing an emote.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            } else {
                playerEmotes.put(player, clazz.getConstructor(EntityPlayer.class, ModelBiped.class, ModelBiped.class, ModelBiped.class).newInstance(player, model, armorModel, armorLegModel));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateEmotes(Entity e) {
        EntityPlayer player;
        if (e instanceof EntityPlayer && playerEmotes.containsKey(player = (EntityPlayer)e)) {
            EmoteBase emote = playerEmotes.get(player);
            if (emote.isDone()) {
                playerEmotes.remove(player);
                EmoteHandler.resetModel(EmoteHandler.getPlayerModel());
                EmoteHandler.resetModel(EmoteHandler.getPlayerArmorModel());
                EmoteHandler.resetModel(EmoteHandler.getPlayerArmorLegModel());
            } else {
                emote.update(!updatedPlayers.contains(player));
            }
            updatedPlayers.add(player);
        }
    }

    public static void clearPlayerList() {
        updatedPlayers.clear();
    }

    private static ModelBiped getPlayerModel() {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class);
        return render.field_77109_a;
    }

    private static ModelBiped getPlayerArmorModel() {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class);
        return render.field_77108_b;
    }

    private static ModelBiped getPlayerArmorLegModel() {
        RenderPlayer render = (RenderPlayer)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class);
        return render.field_77111_i;
    }

    private static void resetModel(ModelBiped model) {
        model.field_78116_c.field_78808_h = 0.0f;
        model.field_78114_d.field_78808_h = 0.0f;
        model.field_78115_e.field_78808_h = 0.0f;
        model.field_78123_h.field_78808_h = 0.0f;
        model.field_78124_i.field_78808_h = 0.0f;
    }

    public static IChatComponent buildEmoteListStr() {
        String split = "{\"text\":\", \"},";
        String button = "{\"text\":\"[%emote%]\",\"color\":\"aqua\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/emote %emote%\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"%emote% - Click to execute this emote\",\"color\":\"yellow\"}}},";
        String str = "[{\"text\":\"Emote List: \"},";
        int i = 0;
        for (String emote : emoteMap.keySet()) {
            String btn = "{\"text\":\"[%emote%]\",\"color\":\"aqua\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/emote %emote%\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"%emote% - Click to execute this emote\",\"color\":\"yellow\"}}},".replaceAll("%emote%", emote);
            if (i % 2 != 0) {
                btn = btn.replaceAll("aqua", "green");
            }
            str = str + btn + "{\"text\":\", \"},";
            ++i;
        }
        str = str.replaceAll(Pattern.quote(",{\"text\":\", \"},") + "$", "]");
        return IChatComponent.Serializer.func_150699_a((String)str);
    }
}

