/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Quat
implements Copyable<Quat> {
    public double x;
    public double y;
    public double z;
    public double s;

    public Quat() {
        this.s = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Quat(Quat quat) {
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.s = quat.s;
    }

    public Quat(double d, double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.s = d;
    }

    public Quat set(Quat quat) {
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.s = quat.s;
        return this;
    }

    public Quat set(double d, double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.s = d;
        return this;
    }

    public static Quat aroundAxis(double d, double d2, double d3, double d4) {
        return new Quat().setAroundAxis(d, d2, d3, d4);
    }

    public static Quat aroundAxis(Vector3 vector3, double d) {
        return Quat.aroundAxis(vector3.x, vector3.y, vector3.z, d);
    }

    public Quat setAroundAxis(double d, double d2, double d3, double d4) {
        double d5 = MathHelper.sin(d4 *= 0.5);
        return this.set(MathHelper.cos(d4), d * d5, d2 * d5, d3 * d5);
    }

    public Quat setAroundAxis(Vector3 vector3, double d) {
        return this.setAroundAxis(vector3.x, vector3.y, vector3.z, d);
    }

    public Quat multiply(Quat quat) {
        double d = this.s * quat.s - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        double d2 = this.s * quat.x + this.x * quat.s - this.y * quat.z + this.z * quat.y;
        double d3 = this.s * quat.y + this.x * quat.z + this.y * quat.s - this.z * quat.x;
        double d4 = this.s * quat.z - this.x * quat.y + this.y * quat.x + this.z * quat.s;
        this.s = d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Quat rightMultiply(Quat quat) {
        double d = this.s * quat.s - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        double d2 = this.s * quat.x + this.x * quat.s + this.y * quat.z - this.z * quat.y;
        double d3 = this.s * quat.y - this.x * quat.z + this.y * quat.s + this.z * quat.x;
        double d4 = this.s * quat.z + this.x * quat.y - this.y * quat.x + this.z * quat.s;
        this.s = d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.s * this.s);
    }

    public Quat normalize() {
        double d = this.mag();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x *= d;
            this.y *= d;
            this.z *= d;
            this.s *= d;
        }
        return this;
    }

    @Override
    public Quat copy() {
        return new Quat(this);
    }

    public void rotate(Vector3 vector3) {
        double d = -this.x * vector3.x - this.y * vector3.y - this.z * vector3.z;
        double d2 = this.s * vector3.x + this.y * vector3.z - this.z * vector3.y;
        double d3 = this.s * vector3.y - this.x * vector3.z + this.z * vector3.x;
        double d4 = this.s * vector3.z + this.x * vector3.y - this.y * vector3.x;
        vector3.x = d2 * this.s - d * this.x - d3 * this.z + d4 * this.y;
        vector3.y = d3 * this.s - d * this.y + d2 * this.z - d4 * this.x;
        vector3.z = d4 * this.s - d * this.z - d2 * this.y + d3 * this.x;
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Quat(" + new BigDecimal(this.s, mathContext) + ", " + new BigDecimal(this.x, mathContext) + ", " + new BigDecimal(this.y, mathContext) + ", " + new BigDecimal(this.z, mathContext) + ")";
    }

    public Rotation rotation() {
        return new Rotation(this);
    }
}

