/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.mod.updater.ReleaseVersion;
import cpw.mods.fml.common.versioning.ArtifactVersion;

public class ModVersion
implements ArtifactVersion {
    private final String _label;
    private final ReleaseVersion _mcVer;
    private final ReleaseVersion _modVer;
    private final String _desc;

    public ReleaseVersion minecraftVersion() {
        return this._mcVer;
    }

    public ReleaseVersion modVersion() {
        return this._modVer;
    }

    public String description() {
        return this._desc;
    }

    public ModVersion(String string, ReleaseVersion releaseVersion, ReleaseVersion releaseVersion2, String string2) {
        this._label = string;
        this._mcVer = releaseVersion;
        this._modVer = releaseVersion2;
        this._desc = string2;
    }

    public ModVersion(String string, String string2) {
        String[] stringArray = string2.split(" ", 2);
        String string3 = "";
        if (stringArray.length > 1) {
            string3 = stringArray[1].trim();
        }
        stringArray = stringArray[0].split("R", 2);
        this._label = string;
        this._mcVer = new ReleaseVersion("Minecraft", stringArray[0]);
        this._modVer = new ReleaseVersion(string, stringArray[1]);
        this._desc = string3;
    }

    public static ModVersion parse(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new ModVersion(string, string2);
    }

    public int compareTo(ArtifactVersion artifactVersion) {
        if (artifactVersion instanceof ModVersion) {
            return this.compareTo((ModVersion)artifactVersion);
        }
        if (artifactVersion instanceof ReleaseVersion) {
            ReleaseVersion releaseVersion = (ReleaseVersion)artifactVersion;
            if (this._label.equals(releaseVersion.getLabel())) {
                return this._modVer.compareTo(releaseVersion);
            }
            if ("Minecraft".equals(releaseVersion.getLabel())) {
                return this._mcVer.compareTo(releaseVersion);
            }
        }
        return 0;
    }

    public int compareTo(ModVersion modVersion) {
        if (this._mcVer.compareTo(modVersion.minecraftVersion()) != 0) {
            return this._mcVer.compareTo(modVersion.minecraftVersion());
        }
        return this._modVer.compareTo(modVersion.modVersion());
    }

    public String toString() {
        return this._modVer.toString() + " for " + this._mcVer.toString();
    }

    public String getVersionString() {
        return this._mcVer.getVersionString() + "R" + this._modVer.getVersionString();
    }

    public String getLabel() {
        return this._label;
    }

    public boolean containsVersion(ArtifactVersion artifactVersion) {
        return this.compareTo(artifactVersion) == 0;
    }

    public String getRangeString() {
        return null;
    }
}

