/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world;

import cofh.CoFHCore;
import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureHandler;
import cofh.core.world.TickHandlerWorld;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.position.ChunkCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldHandler
implements IWorldGenerator,
IFeatureHandler {
    private static List<IFeatureGenerator> features = new ArrayList<IFeatureGenerator>();
    private static Set<String> featureNames = new THashSet();
    private static Set<OreGenEvent.GenerateMinable.EventType> vanillaGenEvents = new THashSet();
    private static long genHash = 0L;
    public static final int MAX_BEDROCK_LAYERS = 8;
    public static boolean allowCustomGen = false;
    public static boolean genFlatBedrock = false;
    public static boolean genReplaceVanilla = false;
    public static boolean retroFlatBedrock = false;
    public static boolean retroGeneration = false;
    public static boolean forceFullRegeneration = false;
    public static ArrayList<String> registeredFeatureNames = new ArrayList();
    private static final String TAG_NAME = "CoFHWorld";
    public static int layersBedrock = 1;
    public static WorldHandler instance = new WorldHandler();

    public static void initialize() {
        String string = "World";
        String string2 = null;
        string2 = "This allows for vanilla Minecraft ore generation to be REPLACED. Configure in the Vanilla.json file; vanilla defaults have been provided. If you rename the Vanilla.json file, this option WILL NOT WORK.";
        genReplaceVanilla = CoFHCore.configCore.get(string, "ReplaceVanillaGeneration", false, string2);
        string2 = "This will flatten the bedrock layer.";
        genFlatBedrock = CoFHCore.configCore.get(string, "FlatBedrock", false, string2);
        string2 = "The number of layers of bedrock to flatten to. (Max: 8)";
        layersBedrock = CoFHCore.configCore.get(string, "FlatBedrockLayers", 1, string2);
        layersBedrock = MathHelper.clampI(layersBedrock, 1, 8);
        string2 = "If FlatBedrock is enabled, this will enforce it in previously generated chunks.";
        retroFlatBedrock = CoFHCore.configCore.get(string, "RetroactiveFlatBedrock", false, string2);
        string2 = "This will retroactively generate ores in previously generated chunks.";
        retroGeneration = CoFHCore.configCore.get(string, "RetroactiveOreGeneration", false, string2);
        GameRegistry.registerWorldGenerator((IWorldGenerator)instance, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.ORE_GEN_BUS.register((Object)instance);
        if (genFlatBedrock & retroFlatBedrock | retroGeneration) {
            FMLCommonHandler.instance().bus().register((Object)TickHandlerWorld.instance);
        }
    }

    public boolean removeFeature(IFeatureGenerator iFeatureGenerator) {
        String string = iFeatureGenerator.getFeatureName();
        if (string == null) {
            return false;
        }
        if (featureNames.contains(string)) {
            featureNames.remove(string);
            features.remove(iFeatureGenerator);
            genHash -= (long)string.hashCode();
        }
        return true;
    }

    private WorldHandler() {
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save save) {
        NBTTagCompound nBTTagCompound = save.getData().func_74775_l(TAG_NAME);
        if (genFlatBedrock) {
            nBTTagCompound.func_74757_a("Bedrock", true);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < features.size(); ++i) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagString(features.get(i).getFeatureName()));
        }
        nBTTagCompound.func_74782_a("List", (NBTBase)nBTTagList);
        nBTTagCompound.func_74772_a("Hash", genHash);
        save.getData().func_74782_a(TAG_NAME, (NBTBase)nBTTagCompound);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load load) {
        int n = load.world.field_73011_w.field_76574_g;
        boolean bl = false;
        NBTTagCompound nBTTagCompound = (NBTTagCompound)load.getData().func_74781_a(TAG_NAME);
        NBTTagList nBTTagList = null;
        ChunkCoord chunkCoord = new ChunkCoord(load.getChunk());
        if (nBTTagCompound != null) {
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = bl2 = retroFlatBedrock & genFlatBedrock && !nBTTagCompound.func_74764_b("Bedrock");
            if (retroGeneration) {
                boolean bl5 = bl3 = nBTTagCompound.func_74763_f("Hash") != genHash;
                if (nBTTagCompound.func_74764_b("List")) {
                    nBTTagList = nBTTagCompound.func_150295_c("List", 8);
                    bl3 |= nBTTagList.func_74745_c() != features.size();
                }
            }
            if (bl2) {
                CoFHCore.log.info("Queuing RetroGen for flattening bedrock for the chunk at " + chunkCoord.toString() + ".");
                bl = true;
            }
            if (bl3) {
                CoFHCore.log.info("Queuing RetroGen for features for the chunk at " + chunkCoord.toString() + ".");
                bl = true;
            }
        } else {
            bl = retroFlatBedrock & genFlatBedrock | retroGeneration;
        }
        if (bl) {
            ArrayDeque arrayDeque = (ArrayDeque)TickHandlerWorld.chunksToGen.get(n);
            if (arrayDeque == null) {
                TickHandlerWorld.chunksToGen.put(n, new ArrayDeque(128));
                arrayDeque = (ArrayDeque)TickHandlerWorld.chunksToGen.get(n);
            }
            if (arrayDeque != null) {
                arrayDeque.addLast(new TickHandlerWorld.RetroChunkCoord(chunkCoord, nBTTagList));
                TickHandlerWorld.chunksToGen.put(n, (Object)arrayDeque);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void handleOreGenEvent(OreGenEvent.GenerateMinable generateMinable) {
        if (!genReplaceVanilla) {
            return;
        }
        if (vanillaGenEvents.contains(generateMinable.type)) {
            generateMinable.setResult(Event.Result.DENY);
        }
    }

    public void generate(Random random, int n, int n2, World world, IChunkProvider iChunkProvider, IChunkProvider iChunkProvider2) {
        this.generateWorld(random, n, n2, world, true);
    }

    @Override
    public boolean registerFeature(IFeatureGenerator iFeatureGenerator) {
        String string = iFeatureGenerator.getFeatureName();
        if (string == null) {
            CoFHCore.log.error("Feature attempted to register without providing a valid name... ignoring.");
            return false;
        }
        if (featureNames.contains(string)) {
            CoFHCore.log.debug("Feature " + string + " was attempting to register a second time... ignoring.");
            return false;
        }
        featureNames.add(string);
        features.add(iFeatureGenerator);
        genHash += (long)string.hashCode();
        return true;
    }

    public static boolean addFeature(IFeatureGenerator iFeatureGenerator) {
        return instance.registerFeature(iFeatureGenerator);
    }

    public void generateWorld(Random random, int n, int n2, World world, boolean bl) {
        this.replaceBedrock(random, n, n2, world, bl | forceFullRegeneration);
        if (!bl & !retroGeneration) {
            return;
        }
        for (IFeatureGenerator iFeatureGenerator : features) {
            iFeatureGenerator.generateFeature(random, n, n2, world, bl | forceFullRegeneration);
        }
        if (!bl) {
            world.func_72964_e(n, n2).func_76630_e();
        }
    }

    public void generateWorld(Random random, TickHandlerWorld.RetroChunkCoord retroChunkCoord, World world, boolean bl) {
        int n = retroChunkCoord.coord.chunkX;
        int n2 = retroChunkCoord.coord.chunkZ;
        if ((bl | retroGeneration) & forceFullRegeneration) {
            this.generateWorld(random, n, n2, world, bl);
            return;
        }
        this.replaceBedrock(random, n, n2, world, bl | forceFullRegeneration);
        if (!bl & !retroGeneration) {
            return;
        }
        THashSet<String> tHashSet = retroChunkCoord.generatedFeatures;
        for (IFeatureGenerator iFeatureGenerator : features) {
            if (tHashSet.contains((Object)iFeatureGenerator.getFeatureName())) continue;
            iFeatureGenerator.generateFeature(random, n, n2, world, bl | forceFullRegeneration);
        }
        if (!bl) {
            world.func_72964_e(n, n2).func_76630_e();
        }
    }

    public void replaceBedrock(Random random, int n, int n2, World world, boolean bl) {
        int n3;
        int n4;
        int n5;
        if (!genFlatBedrock | !bl & !retroFlatBedrock) {
            return;
        }
        Block block = world.func_72807_a((int)n, (int)n2).field_76753_B;
        int n6 = 0;
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                block = Blocks.field_150424_aL;
                break;
            }
            case 0: {
                block = Blocks.field_150348_b;
                break;
            }
            case 1: {
                block = Blocks.field_150377_bs;
            }
        }
        int n7 = n * 16;
        int n8 = n2 * 16;
        for (n5 = 0; n5 < 16; ++n5) {
            for (n4 = 0; n4 < 16; ++n4) {
                for (n3 = 5; n3 > layersBedrock - 1; --n3) {
                    if (world.func_147439_a(n7 + n5, n3, n8 + n4) != Blocks.field_150357_h) continue;
                    world.func_147465_d(n7 + n5, n3, n8 + n4, block, n6, 2);
                }
                for (n3 = layersBedrock - 1; n3 > 0; --n3) {
                    if (world.func_147439_a(n7 + n5, n3, n8 + n4) == Blocks.field_150350_a) continue;
                    world.func_147465_d(n7 + n5, n3, n8 + n4, Blocks.field_150357_h, 0, 2);
                }
            }
        }
        n5 = world.func_72940_L();
        if (world.func_147439_a(n7, n5 - 1, n8) == Blocks.field_150357_h) {
            for (n4 = 0; n4 < 16; ++n4) {
                for (n3 = 0; n3 < 16; ++n3) {
                    int n9;
                    for (n9 = n5 - 2; n9 > n5 - 6; --n9) {
                        if (world.func_147439_a(n7 + n4, n9, n8 + n3) != Blocks.field_150357_h) continue;
                        world.func_147465_d(n7 + n4, n9, n8 + n3, block, n6, 2);
                    }
                    for (n9 = n5 - layersBedrock; n9 < n5 - 1; ++n9) {
                        if (world.func_147439_a(n7 + n4, n9, n8 + n3) == Blocks.field_150350_a) continue;
                        world.func_147465_d(n7 + n4, n9, n8 + n3, Blocks.field_150357_h, 0, 2);
                    }
                }
            }
        }
    }

    static {
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.COAL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIAMOND);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIRT);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GOLD);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GRAVEL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.IRON);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.LAPIS);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.REDSTONE);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.QUARTZ);
    }
}

