/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.profilers;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.server.MinecraftServer;

public class DeadManSwitch
implements Runnable {
    public static DeadManSwitch instance;
    private Thread serverThread = null;
    private MinecraftServer server = null;
    private AtomicLong timer = new AtomicLong();
    private AtomicLong timerPrev = new AtomicLong();
    private Long lastTested = 0L;
    private long nderps = 0L;
    private BlockingQueue<Long> queue = new ArrayBlockingQueue<Long>(2);

    public DeadManSwitch(MinecraftServer server, Thread serverThread) {
        this.server = server;
        this.serverThread = serverThread;
        instance = this;
    }

    public void setTimer(long time) {
        this.timerPrev.set(this.timer.get());
        this.timer.set(time);
    }

    public long getTimerDelta() {
        return this.timer.get() - this.timerPrev.get();
    }

    @Override
    public void run() {
        System.out.printf("Starting Dead Man Switch\n", new Object[0]);
        while (true) {
            try {
                if (this.lastTested.longValue() != this.timer.get() && (double)this.getTimerDelta() / 1000.0 / 1000.0 > 300.0) {
                    System.out.printf("==== Main thread is staled ! %.3f ms [ %d ]====\n", (double)this.getTimerDelta() / 1000.0 / 1000.0, this.nderps);
                    ++this.nderps;
                    if (this.nderps > 10L) {
                        for (Thread thread : Thread.getAllStackTraces().keySet()) {
                            if (thread == Thread.currentThread()) continue;
                            try {
                                thread.interrupt();
                            }
                            catch (Exception e) {
                                System.out.printf("%s\n", e);
                            }
                        }
                        return;
                    }
                }
                this.lastTested = this.timer.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            LockSupport.parkNanos(1000000L);
        }
    }

    public static DeadManSwitch startDeadManSwitch(MinecraftServer server) {
        DeadManSwitch deadManSwitch = new DeadManSwitch(server, Thread.currentThread());
        Thread deadManSwitchThrd = new Thread(deadManSwitch);
        deadManSwitchThrd.setName("Dead Man Switch");
        deadManSwitchThrd.setPriority(10);
        deadManSwitchThrd.start();
        return deadManSwitch;
    }
}

