/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockFertileLilypad;

@ContentInit
public class ItemHarvestRod
extends ItemToggleable {
    public ItemHarvestRod() {
        super("harvest_rod");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip(ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger((String)"bonemeal", (ItemStack)ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.WHITE + Items.field_151100_aR.func_77653_i(new ItemStack(Items.field_151100_aR, 1, 15)))), (ItemStack)ist, (List)list);
        }
        LanguageHelper.formatTooltip((String)"tooltip.absorb", null, (ItemStack)ist, (List)list);
    }

    public boolean func_77662_d() {
        return true;
    }

    public int getBonemealLimit() {
        return Reliquary.CONFIG.getInt("harvest_rod", "bonemeal_limit");
    }

    public int getBonemealWorth() {
        return Reliquary.CONFIG.getInt("harvest_rod", "bonemeal_worth");
    }

    public int getBonemealCost() {
        return Reliquary.CONFIG.getInt("harvest_rod", "bonemeal_cost");
    }

    public int getLuckRolls() {
        return Reliquary.CONFIG.getInt("harvest_rod", "bonemeal_luck_rolls");
    }

    public int getLuckPercent() {
        return Reliquary.CONFIG.getInt("harvest_rod", "bonemeal_luck_percent_chance");
    }

    public int getBreakRadius() {
        return Reliquary.CONFIG.getInt("harvest_rod", "harvest_break_radius");
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist) && NBTHelper.getInteger((String)"bonemeal", (ItemStack)ist) + this.getBonemealWorth() <= this.getBonemealLimit() && InventoryHelper.consumeItem((Object)new ItemStack(Items.field_151100_aR, 1, 15), (EntityPlayer)player)) {
            NBTHelper.setInteger((String)"bonemeal", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"bonemeal", (ItemStack)ist) + this.getBonemealWorth()));
        }
    }

    public boolean onBlockStartBreak(ItemStack ist, int x, int y, int z, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block instanceof IPlantable || block instanceof IGrowable) {
            for (int xOff = -this.getBreakRadius(); xOff <= this.getBreakRadius(); ++xOff) {
                for (int yOff = -this.getBreakRadius(); yOff <= this.getBreakRadius(); ++yOff) {
                    for (int zOff = -this.getBreakRadius(); zOff <= this.getBreakRadius(); ++zOff) {
                        this.doHarvestBlockBreak(ist, x, y, z, player, xOff, yOff, zOff);
                    }
                }
            }
        }
        return true;
    }

    public void doHarvestBlockBreak(ItemStack ist, int x, int y, int z, EntityPlayer player, int xOff, int yOff, int zOff) {
        Block block = player.field_70170_p.func_147439_a(x += xOff, y += yOff, z += zOff);
        if (!(block instanceof IPlantable) && !(block instanceof BlockCrops)) {
            return;
        }
        if (block instanceof BlockFertileLilypad) {
            return;
        }
        ArrayList drops = block.getDrops(player.field_70170_p, x, y, z, player.field_70170_p.func_72805_g(x, y, z), EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)ist));
        Random rand = new Random();
        if (player.field_70170_p.field_72995_K) {
            for (int particles = 0; particles <= 8; ++particles) {
                player.field_70170_p.func_72889_a(player, 2001, x, y, z, Block.func_149682_b((Block)block) + (player.field_70170_p.func_72805_g(x, y, z) << 12));
            }
        } else {
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
            player.func_71020_j(0.01f);
        }
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (NBTHelper.getInteger((String)"bonemeal", (ItemStack)ist) >= this.getBonemealCost()) {
            ItemStack fakeItemStack = new ItemStack(Items.field_151100_aR, 1, 15);
            ItemDye fakeItemDye = (ItemDye)fakeItemStack.func_77973_b();
            boolean usedRod = false;
            for (int repeatedUses = 0; repeatedUses <= this.getLuckRolls(); ++repeatedUses) {
                if (repeatedUses != 0 && world.field_73012_v.nextInt(100) > this.getLuckPercent() || !fakeItemDye.func_77648_a(fakeItemStack, player, world, x, y, z, side, xOff, yOff, zOff)) continue;
                if (!usedRod) {
                    usedRod = true;
                }
                player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
            }
            if (usedRod) {
                NBTHelper.setInteger((String)"bonemeal", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"bonemeal", (ItemStack)ist) - this.getBonemealCost()));
            }
        }
        return true;
    }
}

