/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.entities.EntityEnderStaffProjectile;

@ContentInit
public class ItemEnderStaff
extends ItemToggleable {
    public ItemEnderStaff() {
        super("ender_staff");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public boolean func_77662_d() {
        return true;
    }

    private int getEnderStaffPearlCost() {
        return Reliquary.CONFIG.getInt("ender_staff", "ender_pearl_cast_cost");
    }

    private int getEnderStaffNodeWarpCost() {
        return Reliquary.CONFIG.getInt("ender_staff", "ender_pearl_node_warp_cost");
    }

    private int getEnderPearlWorth() {
        return Reliquary.CONFIG.getInt("ender_staff", "ender_pearl_worth");
    }

    private int getEnderPearlLimit() {
        return Reliquary.CONFIG.getInt("ender_staff", "ender_pearl_limit");
    }

    private int getNodeWarpCastTime() {
        return Reliquary.CONFIG.getInt("ender_staff", "node_warp_cast_time");
    }

    public float getDigSpeed(ItemStack ist, Block block, int meta) {
        if (ist.func_77960_j() == 0) {
            ist.func_77964_b(1);
        }
        return 0.0f;
    }

    public String getMode(ItemStack ist) {
        if (NBTHelper.getString((String)"mode", (ItemStack)ist).equals("")) {
            this.setMode(ist, "cast");
        }
        return NBTHelper.getString((String)"mode", (ItemStack)ist);
    }

    public void setMode(ItemStack ist, String s) {
        NBTHelper.setString((String)"mode", (ItemStack)ist, (String)s);
    }

    public void cycleMode(ItemStack ist) {
        if (this.getMode(ist).equals("cast")) {
            this.setMode(ist, "long_cast");
        } else if (this.getMode(ist).equals("long_cast")) {
            this.setMode(ist, "node_warp");
        } else {
            this.setMode(ist, "cast");
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack ist) {
        if (entityLiving.field_70170_p.field_72995_K) {
            return true;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(ist);
        }
        return false;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.isEnabled(ist)) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist) + this.getEnderPearlWorth() <= this.getEnderPearlLimit() && InventoryHelper.consumeItem((Object)new ItemStack(Items.field_151079_bi), (EntityPlayer)player)) {
            NBTHelper.setInteger((String)"ender_pearls", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist) + this.getEnderPearlWorth()));
        }
    }

    public void onUsingTick(ItemStack ist, EntityPlayer player, int unadjustedCount) {
        for (int particles = 0; particles < 2; ++particles) {
            player.field_70170_p.func_72869_a("portal", player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian(), player.field_70170_p.field_73012_v.nextGaussian());
        }
        if (unadjustedCount == 1) {
            this.doWraithNodeWarpCheck(ist, player.field_70170_p, player);
        }
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return this.getNodeWarpCastTime();
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            if (this.getMode(ist).equals("cast") || this.getMode(ist).equals("long_cast")) {
                if (player.field_82175_bq) {
                    return ist;
                }
                player.func_71038_i();
                if (NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist) < this.getEnderStaffPearlCost()) {
                    return ist;
                }
                player.field_70170_p.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)new EntityEnderStaffProjectile(player.field_70170_p, player, !this.getMode(ist).equals("long_cast")));
                    NBTHelper.setInteger((String)"ender_pearls", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist) - this.getEnderStaffPearlCost()));
                }
            } else {
                player.func_71008_a(ist, this.func_77626_a(ist));
            }
        }
        return super.func_77659_a(ist, world, player);
    }

    private ItemStack doWraithNodeWarpCheck(ItemStack ist, World world, EntityPlayer player) {
        if (NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist) < this.getEnderStaffNodeWarpCost()) {
            return ist;
        }
        if (ist.func_77978_p() != null && ist.func_77978_p().func_74762_e("dimensionID") != Integer.valueOf(this.getWorld(player)).intValue()) {
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Out of range!"));
            }
        } else if (ist.func_77978_p() != null && ContentHelper.areBlocksEqual((Block)world.func_147439_a(ist.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)), ist.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)), ist.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player))), (Block)Reliquary.CONTENT.getBlock("wraith_node"))) {
            if (this.canTeleport(world, ist.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)), ist.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)), ist.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)))) {
                this.teleportPlayer(world, ist.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)), ist.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)), ist.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)), player);
                NBTHelper.setInteger((String)"ender_pearls", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist) - this.getEnderStaffNodeWarpCost()));
            }
        } else if (ist.func_77978_p() != null && ist.func_77978_p().func_74764_b("dimensionID")) {
            ist.func_77978_p().func_82580_o("dimensionID");
            ist.func_77978_p().func_82580_o("nodeX");
            ist.func_77978_p().func_82580_o("nodeY");
            ist.func_77978_p().func_82580_o("nodeZ");
            ist.func_77978_p().func_82580_o("cooldown");
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + "Node dosen't exist!"));
            } else {
                player.func_85030_a("mob.endermen.death", 1.0f, 1.0f);
            }
        }
        return ist;
    }

    private boolean canTeleport(World world, int x, int y, int z) {
        return world.func_147437_c(x, y + 1, z) && world.func_147437_c(x, y + 2, z);
    }

    private void teleportPlayer(World world, int x, int y, int z, EntityPlayer player) {
        player.func_70634_a((double)x + 0.5, (double)y + 0.875, (double)z + 0.5);
        player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        for (int particles = 0; particles < 2; ++particles) {
            world.func_72869_a("portal", player.field_70165_t, player.field_70163_u, player.field_70161_v, world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
        }
    }

    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean flag) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        String charge = Integer.toString(NBTHelper.getInteger((String)"ender_pearls", (ItemStack)ist));
        String phrase = "Currently bound to ";
        String position = "";
        if (ist.func_77978_p() != null && ist.func_77978_p().func_74762_e("dimensionID") != Integer.valueOf(this.getWorld(player)).intValue()) {
            phrase = "Out of range!";
        } else {
            position = ist.func_77978_p() != null && ist.func_77978_p().func_74764_b("nodeX" + this.getWorld(player)) && ist.func_77978_p().func_74764_b("nodeY" + this.getWorld(player)) && ist.func_77978_p().func_74764_b("nodeZ" + this.getWorld(player)) ? "X: " + ist.func_77978_p().func_74762_e("nodeX" + this.getWorld(player)) + " Y: " + ist.func_77978_p().func_74762_e("nodeY" + this.getWorld(player)) + " Z: " + ist.func_77978_p().func_74762_e("nodeZ" + this.getWorld(player)) : "nowhere.";
        }
        this.formatTooltip(ImmutableMap.of((Object)"phrase", (Object)phrase, (Object)"position", (Object)position, (Object)"charge", (Object)charge), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.GREEN + Items.field_151079_bi.func_77653_i(new ItemStack(Items.field_151079_bi)))), (ItemStack)ist, (List)list);
        }
        LanguageHelper.formatTooltip((String)"tooltip.absorb", null, (ItemStack)ist, (List)list);
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if ((ist.func_77978_p() == null || !ist.func_77978_p().func_74764_b("dimensionID")) && ContentHelper.areBlocksEqual((Block)world.func_147439_a(x, y, z), (Block)Reliquary.CONTENT.getBlock("wraith_node"))) {
            this.setWraithNode(ist, x, y, z, Integer.valueOf(this.getWorld(player)), player);
            player.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
            for (int particles = 0; particles < 12; ++particles) {
                world.func_72869_a("portal", (double)x + world.field_73012_v.nextDouble(), (double)y + world.field_73012_v.nextDouble(), (double)z + world.field_73012_v.nextDouble(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian(), world.field_73012_v.nextGaussian());
            }
            return true;
        }
        return false;
    }

    public void setWraithNode(ItemStack eye, int x, int y, int z, int dimensionID, EntityPlayer player) {
        NBTHelper.setInteger((String)("nodeX" + this.getWorld(player)), (ItemStack)eye, (int)x);
        NBTHelper.setInteger((String)("nodeY" + this.getWorld(player)), (ItemStack)eye, (int)y);
        NBTHelper.setInteger((String)("nodeZ" + this.getWorld(player)), (ItemStack)eye, (int)z);
        NBTHelper.setInteger((String)"dimensionID", (ItemStack)eye, (int)dimensionID);
    }

    public String getWorld(EntityPlayer player) {
        return Integer.valueOf(player.field_70170_p.field_73011_w.field_76574_g).toString();
    }
}

