/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import xreliquary.Reliquary;

@ContentInit
public class ItemEmperorChalice
extends ItemToggleable {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconOverlay;

    public ItemEmperorChalice() {
        super("emperor_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.iconOverlay = iconRegister.func_94245_a("xreliquary".toLowerCase() + ":" + "emperor_chalice_overlay");
    }

    public IIcon getIcon(ItemStack itemStack, int renderPass) {
        if (this.isEnabled(itemStack) || renderPass != 1) {
            return this.field_77791_bV;
        }
        return this.iconOverlay;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 16;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.epic;
    }

    public ItemStack func_77654_b(ItemStack ist, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return ist;
        }
        int multiplier = (Integer)Reliquary.CONFIG.get("emperor_chalice", "hunger_satiation_multiplier");
        player.func_71024_bL().func_75122_a(1, (float)(multiplier / 2));
        player.func_70097_a(DamageSource.field_76369_e, (float)multiplier);
        return ist;
    }

    public ItemStack func_77659_a(ItemStack ist, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            return super.func_77659_a(ist, world, player);
        }
        float coeff = 1.0f;
        double xOff = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)coeff;
        double yOff = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)coeff + 1.62 - (double)player.field_70129_M;
        double zOff = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)coeff;
        boolean isInDrainMode = this.isEnabled(ist);
        MovingObjectPosition mop = this.func_77621_a(world, player, isInDrainMode);
        if (mop == null) {
            if (!this.isEnabled(ist)) {
                player.func_71008_a(ist, this.func_77626_a(ist));
            }
            return ist;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            TileEntity tile;
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return ist;
            }
            if (!player.func_82247_a(x, y, z, mop.field_72310_e, ist)) {
                return ist;
            }
            if (this.isEnabled(ist)) {
                tile = world.func_147438_o(x, y, z);
                if (tile instanceof IFluidHandler) {
                    FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
                    ((IFluidHandler)tile).drain(ForgeDirection.getOrientation((int)mop.field_72310_e), fluid, true);
                    return ist;
                }
            } else {
                tile = world.func_147438_o(x, y, z);
                if (tile instanceof IFluidHandler) {
                    FluidStack fluid = new FluidStack(FluidRegistry.WATER, 1000);
                    int amount = ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)mop.field_72310_e), fluid, false);
                    if (amount > 0) {
                        ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)mop.field_72310_e), fluid, true);
                    }
                    return ist;
                }
            }
            if (!this.isEnabled(ist)) {
                if (mop.field_72310_e == 0) {
                    --y;
                }
                if (mop.field_72310_e == 1) {
                    ++y;
                }
                if (mop.field_72310_e == 2) {
                    --z;
                }
                if (mop.field_72310_e == 3) {
                    ++z;
                }
                if (mop.field_72310_e == 4) {
                    --x;
                }
                if (mop.field_72310_e == 5) {
                    ++x;
                }
                if (!player.func_82247_a(x, y, z, mop.field_72310_e, ist)) {
                    return ist;
                }
                if (this.tryPlaceContainedLiquid(world, ist, xOff, yOff, zOff, x, y, z)) {
                    return ist;
                }
            } else {
                String ident = ContentHelper.getIdent((Block)world.func_147439_a(x, y, z));
                if ((ident.equals(ContentHelper.getIdent((Block)Blocks.field_150358_i)) || ident.equals(ContentHelper.getIdent((Block)Blocks.field_150355_j))) && world.func_72805_g(x, y, z) == 0) {
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                    return ist;
                }
            }
        }
        return ist;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack ist, double posX, double posY, double posZ, int x, int y, int z) {
        boolean isNotSolid;
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (this.isEnabled(ist)) {
            return false;
        }
        boolean bl = isNotSolid = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !isNotSolid) {
            return false;
        }
        if (world.field_73011_w.field_76575_d) {
            world.func_72908_a(posX + 0.5, posY + 0.5, posZ + 0.5, "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int var11 = 0; var11 < 8; ++var11) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 3);
        }
        return true;
    }
}

