/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.ItemToggleable;
import lib.enderwizards.sandstone.util.ContentHelper;
import lib.enderwizards.sandstone.util.InventoryHelper;
import lib.enderwizards.sandstone.util.LanguageHelper;
import lib.enderwizards.sandstone.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;

@ContentInit
public class ItemDestructionCatalyst
extends ItemToggleable {
    public static List<String> ids = ImmutableList.of((Object)"minecraft:dirt", (Object)"minecraft:grass", (Object)"minecraft:gravel", (Object)"minecraft:cobblestone", (Object)"minecraft:stone", (Object)"minecraft:sand", (Object)"minecraft:sandstone", (Object)"minecraft:snow", (Object)"minecraft:soul_sand", (Object)"minecraft:netherrack", (Object)"minecraft:end_stone");

    public ItemDestructionCatalyst() {
        super("destruction_catalyst");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    public void func_77624_a(ItemStack ist, EntityPlayer player, List list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip(ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger((String)"gunpowder", (ItemStack)ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip((String)"tooltip.absorb_active", (ImmutableMap)ImmutableMap.of((Object)"item", (Object)(EnumChatFormatting.GRAY + Items.field_151016_H.func_77653_i(new ItemStack(Items.field_151016_H)))), (ItemStack)ist, (List)list);
        }
        LanguageHelper.formatTooltip((String)"tooltip.absorb", null, (ItemStack)ist, (List)list);
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xOff, float yOff, float zOff) {
        if (NBTHelper.getInteger((String)"gunpowder", (ItemStack)ist) > this.gunpowderCost() || player.field_71075_bZ.field_75098_d) {
            this.doExplosion(world, x, y, z, side, player, ist);
        }
        return true;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist) && NBTHelper.getInteger((String)"gunpowder", (ItemStack)ist) + this.gunpowderWorth() < this.gunpowderLimit() && InventoryHelper.consumeItem((Object)new ItemStack(Items.field_151016_H), (EntityPlayer)player)) {
            NBTHelper.setInteger((String)"gunpowder", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"gunpowder", (ItemStack)ist) + this.gunpowderWorth()));
        }
    }

    public int getExplosionRadius() {
        return Reliquary.CONFIG.getInt("destruction_catalyst", "explosion_radius");
    }

    public boolean centeredExplosion() {
        return Reliquary.CONFIG.getBool("destruction_catalyst", "centered_explosion");
    }

    public boolean perfectCube() {
        return Reliquary.CONFIG.getBool("destruction_catalyst", "perfect_cube");
    }

    public void doExplosion(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack ist) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        if (!this.centeredExplosion()) {
            y += side == 0 ? this.getExplosionRadius() : (side == 1 ? -this.getExplosionRadius() : 0);
            z += side == 2 ? this.getExplosionRadius() : (side == 3 ? -this.getExplosionRadius() : 0);
            x += side == 4 ? this.getExplosionRadius() : (side == 5 ? -this.getExplosionRadius() : 0);
        }
        for (int xD = -this.getExplosionRadius(); xD <= this.getExplosionRadius(); ++xD) {
            for (int yD = -this.getExplosionRadius(); yD <= this.getExplosionRadius(); ++yD) {
                for (int zD = -this.getExplosionRadius(); zD <= this.getExplosionRadius(); ++zD) {
                    ChunkCoordinates target;
                    ChunkCoordinates origin;
                    double distance;
                    if (!this.perfectCube() && (distance = (double)(origin = new ChunkCoordinates(x, y, z)).func_82371_e(target = new ChunkCoordinates(x + xD, y + yD, z + zD))) >= (double)this.getExplosionRadius() || !this.isBreakable(ContentHelper.getIdent((Block)world.func_147439_a(x + xD, y + yD, z + zD)))) continue;
                    world.func_147449_b(x + xD, y + yD, z + zD, Blocks.field_150350_a);
                    if (world.field_73012_v.nextInt(2) == 0) {
                        world.func_72869_a("largeexplode", (double)((float)(x + xD) + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)(y + yD) + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)(z + zD) + (world.field_73012_v.nextFloat() - 0.5f)), 0.0, 0.0, 0.0);
                    }
                    destroyedSomething = true;
                    if (!playOnce) continue;
                    world.func_72908_a((double)x, (double)y, (double)z, "random.explode", 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    playOnce = false;
                }
            }
        }
        if (destroyedSomething) {
            NBTHelper.setInteger((String)"gunpowder", (ItemStack)ist, (int)(NBTHelper.getInteger((String)"gunpowder", (ItemStack)ist) - this.gunpowderCost()));
        }
    }

    public boolean isBreakable(String id) {
        return ((List)Reliquary.CONFIG.get("destruction_catalyst", "mundane_blocks")).indexOf(id) != -1;
    }

    private int gunpowderCost() {
        return Reliquary.CONFIG.getInt("destruction_catalyst", "gunpowder_cost");
    }

    private int gunpowderWorth() {
        return Reliquary.CONFIG.getInt("destruction_catalyst", "gunpowder_worth");
    }

    private int gunpowderLimit() {
        return Reliquary.CONFIG.getInt("destruction_catalyst", "gunpowder_limit");
    }
}

