/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lib.enderwizards.sandstone.blocks.ICustomItemBlock;
import lib.enderwizards.sandstone.init.ContentInit;
import lib.enderwizards.sandstone.items.block.ItemBlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import xreliquary.Reliquary;

@ContentInit
public class BlockInterdictionTorch
extends BlockTorch
implements ICustomItemBlock {
    public BlockInterdictionTorch() {
        this.func_149663_c("interdiction_torch");
        this.func_149647_a(Reliquary.CREATIVE_TAB);
        this.func_149711_c(0.0f);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(BlockTorch.field_149766_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("xreliquary:interdiction_torch");
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        world.func_147464_a(x, y, z, (Block)this, this.tickRate());
        return super.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, meta);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        world.func_147464_a(x, y, z, (Block)this, this.tickRate());
        if (world.field_72995_K) {
            return;
        }
        int radius = Reliquary.CONFIG.getInt("interdiction_torch", "push_radius");
        List entitiesThatCanBePushed = (List)Reliquary.CONFIG.get("interdiction_torch", "entities_that_can_be_pushed");
        List projectilesThatCanBePushed = (List)Reliquary.CONFIG.get("interdiction_torch", "projectiles_that_can_be_pushed");
        List entities = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius)));
        for (Entity entity : entities) {
            double distance;
            Class<?> entityClass;
            String entityName;
            if (entity instanceof EntityPlayer || !entitiesThatCanBePushed.contains(entityName = (String)EntityList.field_75626_c.get(entityClass = entity.getClass())) && (!projectilesThatCanBePushed.contains(entityName) || !Reliquary.CONFIG.getBool("interdiction_torch", "can_push_projectiles")) || (distance = entity.func_70011_f((double)x, (double)y, (double)z)) >= (double)radius || distance == 0.0) continue;
            if (distance < 1.0) {
                distance = 1.0;
            }
            double knockbackMultiplier = 1.0 + 1.0 / distance;
            double reductionCoefficient = 0.04;
            Vec3 angleOfAttack = Vec3.func_72443_a((double)(entity.field_70165_t - ((double)x + 0.5)), (double)(entity.field_70163_u - (double)y), (double)(entity.field_70161_v - ((double)z + 0.5)));
            double xForce = angleOfAttack.field_72450_a * knockbackMultiplier * reductionCoefficient;
            double yForce = angleOfAttack.field_72448_b * knockbackMultiplier * reductionCoefficient;
            double zForce = angleOfAttack.field_72449_c * knockbackMultiplier * reductionCoefficient;
            entity.field_70159_w += xForce;
            entity.field_70181_x += yForce;
            entity.field_70179_y += zForce;
        }
    }

    public int tickRate() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int orientation = world.func_72805_g(x, y, z);
        double xOffset = (float)x + 0.5f;
        double yOffset = (float)y + 0.7f;
        double zOffset = (float)z + 0.5f;
        double verticalModifier = 0.22f;
        double horizontalModifier = 0.27f;
        if (orientation == 1) {
            world.func_72869_a("mobSpell", xOffset - horizontalModifier, yOffset + verticalModifier, zOffset, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", xOffset - horizontalModifier, yOffset + verticalModifier, zOffset, 0.0, 0.0, 0.0);
        } else if (orientation == 2) {
            world.func_72869_a("mobSpell", xOffset + horizontalModifier, yOffset + verticalModifier, zOffset, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", xOffset + horizontalModifier, yOffset + verticalModifier, zOffset, 0.0, 0.0, 0.0);
        } else if (orientation == 3) {
            world.func_72869_a("mobSpell", xOffset, yOffset + verticalModifier, zOffset - horizontalModifier, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", xOffset, yOffset + verticalModifier, zOffset - horizontalModifier, 0.0, 0.0, 0.0);
        } else if (orientation == 4) {
            world.func_72869_a("mobSpell", xOffset, yOffset + verticalModifier, zOffset + horizontalModifier, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", xOffset, yOffset + verticalModifier, zOffset + horizontalModifier, 0.0, 0.0, 0.0);
        } else {
            world.func_72869_a("mobSpell", xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", xOffset, yOffset, zOffset, 0.0, 0.0, 0.0);
        }
    }

    public Class<? extends ItemBlock> getCustomItemBlock() {
        return ItemBlockBase.class;
    }
}

