/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.util.inventory;

import io.endertech.util.inventory.InventoryAbstracted;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryHelper {
    public static int getExtractableQuantity(InventoryAbstracted inventory, ItemStack stack) {
        int quantity = 0;
        for (int slot : inventory.slots) {
            ItemStack is = inventory.getStackInSlot(slot);
            if (is == null || !is.func_77969_a(stack)) continue;
            quantity += is.field_77994_a;
        }
        return quantity;
    }

    public static int getExtractableQuantity(IInventory inv, ItemStack stack) {
        return InventoryHelper.getExtractableQuantity(new InventoryAbstracted(inv), stack);
    }

    public static int findFirstItemStack(InventoryAbstracted inventory, ItemStack stack) {
        for (int slot : inventory.slots) {
            ItemStack is = inventory.getStackInSlot(slot);
            if (is == null || !is.func_77969_a(stack) || is.field_77994_a <= 0) continue;
            return slot;
        }
        return -1;
    }

    public static int findFirstItemStack(IInventory inv, ItemStack stack) {
        return InventoryHelper.findFirstItemStack(new InventoryAbstracted(inv), stack);
    }

    public static ItemStack insertItem(InventoryAbstracted inventory, ItemStack tStack, boolean simulate) {
        if (tStack == null) {
            return null;
        }
        if (inventory.slots == null) {
            return tStack;
        }
        ItemStack stack = tStack.func_77946_l();
        for (int pass = 1; pass <= 2; ++pass) {
            for (int slot : inventory.slots) {
                boolean canStack;
                ItemStack slotStack = inventory.getStackInSlot(slot);
                if (slotStack == null && pass == 1 || !inventory.canInsertItem(slot, stack)) continue;
                boolean bl = canStack = slotStack == null || slotStack.func_77973_b().equals(stack.func_77973_b()) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)stack) && slotStack.func_77985_e() && stack.func_77985_e() && (!slotStack.func_77981_g() || slotStack.func_77960_j() == stack.func_77960_j());
                if (!canStack) continue;
                int fittable = 0;
                fittable = slotStack == null ? stack.func_77976_d() : slotStack.func_77976_d() - slotStack.field_77994_a;
                if (fittable <= 0) continue;
                int fit = Math.min(fittable, stack.field_77994_a);
                stack.field_77994_a -= fit;
                if (slotStack == null) {
                    slotStack = stack.func_77946_l();
                    slotStack.field_77994_a = 0;
                }
                if (!simulate) {
                    slotStack.field_77994_a += fit;
                    inventory.inventory.func_70299_a(slot, slotStack);
                }
                if (stack.field_77994_a > 0) continue;
                return null;
            }
        }
        return stack;
    }

    public static void consumeItem(IInventory inventory, int slot) {
        inventory.func_70298_a(slot, 1);
    }

    public static ItemStack insertItem(IInventory inventory, ItemStack stack, boolean simulate) {
        return InventoryHelper.insertItem(new InventoryAbstracted(inventory), stack, simulate);
    }

    public static boolean checkAndPutItemStacksInToInventory(IInventory inventory, ArrayList<ItemStack> itemStacks) {
        return InventoryHelper.checkAndPutItemStacksInToInventory(new InventoryAbstracted(inventory), itemStacks);
    }

    public static boolean checkAndPutItemStacksInToInventory(InventoryAbstracted inventory, ArrayList<ItemStack> itemStacks) {
        for (ItemStack droppedItem : itemStacks) {
            if (InventoryHelper.insertItem(inventory, droppedItem, true) == null) continue;
            return false;
        }
        for (ItemStack droppedItem : itemStacks) {
            InventoryHelper.insertItem(inventory, droppedItem, false);
        }
        return true;
    }
}

